/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.transport.RemoteClusterService;

public class ResolvedIndices {
    @Nullable
    private final SearchContextId searchContextId;
    private final Map<String, OriginalIndices> remoteClusterIndices;
    @Nullable
    private final OriginalIndices localIndices;
    private final Map<Index, IndexMetadata> localIndexMetadata;

    ResolvedIndices(Map<String, OriginalIndices> remoteClusterIndices, @Nullable OriginalIndices localIndices, Map<Index, IndexMetadata> localIndexMetadata, @Nullable SearchContextId searchContextId) {
        this.remoteClusterIndices = Collections.unmodifiableMap(remoteClusterIndices);
        this.localIndices = localIndices;
        this.localIndexMetadata = Collections.unmodifiableMap(localIndexMetadata);
        this.searchContextId = searchContextId;
    }

    ResolvedIndices(Map<String, OriginalIndices> remoteClusterIndices, @Nullable OriginalIndices localIndices, Map<Index, IndexMetadata> localIndexMetadata) {
        this(remoteClusterIndices, localIndices, localIndexMetadata, null);
    }

    public Map<String, OriginalIndices> getRemoteClusterIndices() {
        return this.remoteClusterIndices;
    }

    @Nullable
    public OriginalIndices getLocalIndices() {
        return this.localIndices;
    }

    public Map<Index, IndexMetadata> getConcreteLocalIndicesMetadata() {
        return this.localIndexMetadata;
    }

    public Index[] getConcreteLocalIndices() {
        return (Index[])this.localIndexMetadata.keySet().toArray(Index[]::new);
    }

    @Nullable
    public SearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public static ResolvedIndices resolveWithIndicesRequest(IndicesRequest request, ProjectMetadata projectMetadata, IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, long startTimeInMillis) {
        return ResolvedIndices.resolveWithIndexNamesAndOptions(request.indices(), request.indicesOptions(), projectMetadata, indexNameExpressionResolver, remoteClusterService, startTimeInMillis);
    }

    public static ResolvedIndices resolveWithIndexNamesAndOptions(String[] indexNames, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, long startTimeInMillis) {
        Map<String, OriginalIndices> remoteClusterIndices = remoteClusterService.groupIndices(indicesOptions, indexNames);
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        Index[] concreteLocalIndices = localIndices == null ? Index.EMPTY_ARRAY : indexNameExpressionResolver.concreteIndices(projectMetadata, (IndicesRequest)localIndices, startTimeInMillis);
        for (Map.Entry<String, OriginalIndices> indicesPerRemoteClusterAlias : remoteClusterIndices.entrySet()) {
            String[] indices = indicesPerRemoteClusterAlias.getValue().indices();
            if (indices == null) continue;
            for (String index : indices) {
                if (!IndexNameExpressionResolver.hasSelectorSuffix(index)) continue;
                throw new InvalidIndexNameException(index, "Selectors are not yet supported on remote cluster patterns");
            }
        }
        return new ResolvedIndices(remoteClusterIndices, localIndices, ResolvedIndices.resolveLocalIndexMetadata(concreteLocalIndices, projectMetadata, true));
    }

    public static ResolvedIndices resolveWithPIT(PointInTimeBuilder pit, IndicesOptions indicesOptions, ProjectMetadata projectMetadata, NamedWriteableRegistry namedWriteableRegistry) {
        OriginalIndices localIndices;
        Index[] concreteLocalIndices;
        SearchContextId searchContextId = pit.getSearchContextId(namedWriteableRegistry);
        HashMap<String, Set> indicesFromSearchContext = new HashMap<String, Set>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContextId.shards().entrySet()) {
            String clusterAlias = entry.getValue().getClusterAlias();
            if (clusterAlias == null) {
                clusterAlias = "";
            }
            indicesFromSearchContext.computeIfAbsent(clusterAlias, s -> new HashSet()).add(entry.getKey().getIndex());
        }
        Set localIndicesSet = (Set)indicesFromSearchContext.remove("");
        if (localIndicesSet != null) {
            concreteLocalIndices = (Index[])localIndicesSet.toArray(Index[]::new);
            localIndices = new OriginalIndices((String[])localIndicesSet.stream().map(Index::getName).toArray(String[]::new), indicesOptions);
        } else {
            concreteLocalIndices = Index.EMPTY_ARRAY;
            localIndices = null;
        }
        HashMap<String, OriginalIndices> remoteClusterIndices = new HashMap<String, OriginalIndices>();
        for (Map.Entry entry : indicesFromSearchContext.entrySet()) {
            OriginalIndices originalIndices = new OriginalIndices((String[])((Set)entry.getValue()).stream().map(Index::getName).toArray(String[]::new), indicesOptions);
            remoteClusterIndices.put((String)entry.getKey(), originalIndices);
        }
        return new ResolvedIndices(remoteClusterIndices, localIndices, ResolvedIndices.resolveLocalIndexMetadata(concreteLocalIndices, projectMetadata, false), searchContextId);
    }

    public static ResolvedIndices resolveWithIndexExpressions(OriginalIndices localIndices, Map<Index, IndexMetadata> localIndexMetadata, Map<String, ResolvedIndexExpressions> remoteExpressions, IndicesOptions indicesOptions) {
        Map remoteIndices = remoteExpressions.entrySet().stream().collect(HashMap::new, (map, entry) -> {
            String[] indices = (String[])((ResolvedIndexExpressions)entry.getValue()).expressions().stream().filter(expression -> {
                ResolvedIndexExpression.LocalExpressions resolvedExpressions = expression.localExpressions();
                boolean successfulResolution = resolvedExpressions.localIndexResolutionResult() == ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS;
                boolean hasResolvedIndices = !resolvedExpressions.indices().isEmpty();
                return successfulResolution && hasResolvedIndices;
            }).map(ResolvedIndexExpression::original).toArray(String[]::new);
            if (indices.length > 0) {
                map.put((String)entry.getKey(), new OriginalIndices(indices, indicesOptions));
            }
        }, Map::putAll);
        return new ResolvedIndices(remoteIndices, localIndices, localIndexMetadata);
    }

    private static Map<Index, IndexMetadata> resolveLocalIndexMetadata(Index[] concreteLocalIndices, ProjectMetadata projectMetadata, boolean failOnMissingIndex) {
        HashMap<Index, IndexMetadata> localIndexMetadata = new HashMap<Index, IndexMetadata>();
        for (Index index : concreteLocalIndices) {
            IndexMetadata indexMetadata = projectMetadata.index(index);
            if (indexMetadata == null) {
                if (!failOnMissingIndex) continue;
                throw new IndexNotFoundException(index);
            }
            localIndexMetadata.put(index, indexMetadata);
        }
        return localIndexMetadata;
    }
}

