/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.search.vectors.RescoreVectorBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class KnnQuery
extends Query {
    private final String field;
    private final float[] query;
    private final Map<String, Object> options;
    private final List<QueryBuilder> filterQueries;
    public static final String RESCORE_OVERSAMPLE_FIELD = "rescore_oversample";
    private final Integer k;

    public KnnQuery(Source source, String field, float[] query, Integer k, Map<String, Object> options, List<QueryBuilder> filterQueries) {
        super(source);
        assert (k != null && k > 0) : "k must be a positive integer, but was: " + k;
        this.k = k;
        assert (options != null);
        this.field = field;
        this.query = query;
        this.options = options;
        this.filterQueries = new ArrayList<QueryBuilder>(filterQueries);
    }

    protected QueryBuilder asBuilder() {
        RescoreVectorBuilder rescoreVectorBuilder = null;
        Float oversample = (Float)this.options.get(RESCORE_OVERSAMPLE_FIELD);
        if (oversample != null) {
            rescoreVectorBuilder = new RescoreVectorBuilder(oversample.floatValue());
        }
        Float vectorSimilarity = (Float)this.options.get(KnnVectorQueryBuilder.VECTOR_SIMILARITY_FIELD.getPreferredName());
        Integer minCandidates = (Integer)this.options.get("min_candidates");
        Float visitPercentage = (Float)this.options.get(KnnVectorQueryBuilder.VISIT_PERCENTAGE_FIELD.getPreferredName());
        minCandidates = minCandidates == null ? null : Integer.valueOf(Math.max(minCandidates, this.k));
        KnnVectorQueryBuilder queryBuilder = new KnnVectorQueryBuilder(this.field, this.query, this.k, minCandidates, visitPercentage, rescoreVectorBuilder, vectorSimilarity);
        for (QueryBuilder filter : this.filterQueries) {
            queryBuilder.addFilterQuery(filter);
        }
        Number boost = (Number)this.options.get(AbstractQueryBuilder.BOOST_FIELD.getPreferredName());
        if (boost != null) {
            queryBuilder.boost(boost.floatValue());
        }
        return queryBuilder;
    }

    protected String innerToString() {
        return "knn(" + this.field + ", " + Arrays.toString(this.query) + " options={" + String.valueOf(this.options) + "}))";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KnnQuery knnQuery = (KnnQuery)((Object)o);
        return Objects.equals(this.field, knnQuery.field) && Objects.deepEquals(this.query, knnQuery.query) && Objects.equals(this.options, knnQuery.options) && Objects.equals(this.filterQueries, knnQuery.filterQueries);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, Arrays.hashCode(this.query), this.options, this.filterQueries);
    }

    public boolean scorable() {
        return true;
    }

    public boolean containsPlan() {
        return false;
    }

    public List<QueryBuilder> filterQueries() {
        return this.filterQueries;
    }
}

