/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.RuleUtils;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public class ReplaceFieldWithConstantOrNull
extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        AttributeSet.Builder lookupFieldsBuilder = AttributeSet.builder();
        HashMap attrToConstant = new HashMap();
        plan.forEachUp(EsRelation.class, esRelation -> {
            if (esRelation.indexMode() == IndexMode.LOOKUP) {
                lookupFieldsBuilder.addAll(esRelation.output());
            } else if (esRelation.indexMode() == IndexMode.STANDARD) {
                for (Attribute attribute : esRelation.output()) {
                    if (!(attribute instanceof FieldAttribute)) continue;
                    FieldAttribute fa = (FieldAttribute)attribute;
                    String val = localLogicalOptimizerContext.searchStats().constantValue(fa.fieldName());
                    if (val == null) continue;
                    attrToConstant.put(attribute, Literal.of((Expression)attribute, (Object)BytesRefs.toBytesRef((Object)val)));
                }
            }
        });
        AttributeSet lookupFields = lookupFieldsBuilder.build();
        Predicate<FieldAttribute> shouldBeRetained = f -> f.field() instanceof PotentiallyUnmappedKeywordEsField || EsQueryExec.isDocAttribute((Attribute)f) || localLogicalOptimizerContext.searchStats().exists(f.fieldName()) || lookupFields.contains(f);
        return (LogicalPlan)plan.transformUp(p -> this.replaceWithNullOrConstant((LogicalPlan)((Object)p), shouldBeRetained, attrToConstant));
    }

    private LogicalPlan replaceWithNullOrConstant(LogicalPlan plan, Predicate<FieldAttribute> shouldBeRetained, Map<Attribute, Expression> attrToConstant) {
        if (plan instanceof EsRelation) {
            EsRelation relation = (EsRelation)plan;
            List<Attribute> relationOutput = relation.output();
            Tuple<List<Alias>, List<NamedExpression>> aliasedNulls = RuleUtils.aliasedNulls(relationOutput, attr -> {
                FieldAttribute f;
                return attr instanceof FieldAttribute && !shouldBeRetained.test(f = (FieldAttribute)attr);
            });
            List nullLiterals = (List)aliasedNulls.v1();
            List newProjections = (List)aliasedNulls.v2();
            if (nullLiterals.size() == 0) {
                return plan;
            }
            Eval eval = new Eval(plan.source(), relation, nullLiterals);
            return new Project(plan.source(), eval, newProjections);
        }
        if (plan instanceof Eval || plan instanceof Filter || plan instanceof OrderBy || plan instanceof RegexExtract || plan instanceof TopN) {
            return (LogicalPlan)((Object)plan.transformExpressionsOnlyUp(FieldAttribute.class, f -> {
                if (attrToConstant.containsKey(f)) {
                    return (Expression)attrToConstant.get(f);
                }
                return shouldBeRetained.test((FieldAttribute)f) ? f : Literal.of((Expression)f, null);
            }));
        }
        return plan;
    }
}

