/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.FunctionEsField;
import org.elasticsearch.xpack.esql.expression.function.blockloader.BlockLoaderExpression;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public class PushExpressionsToFieldLoad
extends ParameterizedRule<LogicalPlan, LogicalPlan, LocalLogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LocalLogicalOptimizerContext context) {
        Rule rule = new Rule(this, context, plan);
        return (LogicalPlan)plan.transformDown(LogicalPlan.class, rule::doRule);
    }

    private class Rule {
        private final Map<Attribute.IdIgnoringWrapper, Attribute> addedAttrs = new HashMap<Attribute.IdIgnoringWrapper, Attribute>();
        private final LocalLogicalOptimizerContext context;
        private final LogicalPlan plan;
        private List<EsRelation> primaries;
        private boolean planWasTransformed = false;

        private Rule(PushExpressionsToFieldLoad pushExpressionsToFieldLoad, LocalLogicalOptimizerContext context, LogicalPlan plan) {
            this.context = context;
            this.plan = plan;
        }

        private LogicalPlan doRule(LogicalPlan plan) {
            this.planWasTransformed = false;
            if (plan instanceof Eval || plan instanceof Filter || plan instanceof Aggregate) {
                LogicalPlan transformedPlan = (LogicalPlan)((Object)plan.transformExpressionsOnly(Expression.class, e -> {
                    if (e instanceof BlockLoaderExpression) {
                        BlockLoaderExpression ble = (BlockLoaderExpression)e;
                        return this.transformExpression((Expression)e, ble);
                    }
                    return e;
                }));
                if (!this.planWasTransformed) {
                    return plan;
                }
                List<Attribute> previousAttrs = transformedPlan.output();
                List<Attribute> addedAttrsList = this.addedAttrs.values().stream().toList();
                transformedPlan = (LogicalPlan)transformedPlan.transformDown(EsRelation.class, esRelation -> {
                    AttributeSet updatedOutput = esRelation.outputSet().combine(AttributeSet.of((Collection)addedAttrsList));
                    return esRelation.withAttributes(updatedOutput.stream().toList());
                });
                transformedPlan = (LogicalPlan)transformedPlan.transformDown(EsqlProject.class, esProject -> {
                    ArrayList<? extends NamedExpression> projections = new ArrayList<NamedExpression>(esProject.projections());
                    projections.addAll(addedAttrsList);
                    return esProject.withProjections(projections);
                });
                return new EsqlProject(Source.EMPTY, transformedPlan, previousAttrs);
            }
            return plan;
        }

        private Expression transformExpression(Expression e, BlockLoaderExpression ble) {
            BlockLoaderExpression.PushedBlockLoaderExpression fuse = ble.tryPushToFieldLoading(this.context.searchStats());
            if (fuse == null) {
                return e;
            }
            if (!this.anyPrimaryContains(fuse.field())) {
                return e;
            }
            MappedFieldType.FieldExtractPreference preference = this.context.configuration().pragmas().fieldExtractPreference();
            if (!this.context.searchStats().supportsLoaderConfig(fuse.field().fieldName(), fuse.config(), preference)) {
                return e;
            }
            this.planWasTransformed = true;
            return this.replaceFieldsForFieldTransformations(e, fuse);
        }

        private Expression replaceFieldsForFieldTransformations(Expression e, BlockLoaderExpression.PushedBlockLoaderExpression fuse) {
            FunctionEsField functionEsField = new FunctionEsField(fuse.field().field(), e.dataType(), fuse.config());
            String name = Attribute.rawTemporaryName((String[])new String[]{fuse.field().name(), fuse.config().function().toString(), String.valueOf(fuse.config().hashCode())});
            FieldAttribute newFunctionAttr = new FieldAttribute(fuse.field().source(), fuse.field().parentName(), fuse.field().qualifier(), name, (EsField)functionEsField, fuse.field().nullable(), new NameId(), true);
            Attribute.IdIgnoringWrapper key = newFunctionAttr.ignoreId();
            if (this.addedAttrs.containsKey(key)) {
                return (Expression)this.addedAttrs.get(key);
            }
            this.addedAttrs.put(key, (Attribute)newFunctionAttr);
            return newFunctionAttr;
        }

        private List<EsRelation> primaries() {
            if (this.primaries == null) {
                this.primaries = new ArrayList<EsRelation>(2);
                this.plan.forEachUp(EsRelation.class, r -> {
                    if (r.indexMode() != IndexMode.LOOKUP) {
                        this.primaries.add((EsRelation)((Object)r));
                    }
                });
            }
            return this.primaries;
        }

        private boolean anyPrimaryContains(FieldAttribute attr) {
            for (EsRelation primary : this.primaries()) {
                if (!primary.outputSet().contains((Object)attr)) continue;
                return true;
            }
            return false;
        }
    }
}

