/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class MvSlice
extends EsqlScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvSlice", MvSlice::new);
    private final Expression field;
    private final Expression start;
    private final Expression end;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "version"}, description="Returns a subset of the multivalued field using the start and end index values.\nThis is most useful when reading from a function that emits multivalued columns\nin a known order like <<esql-split>> or <<esql-mv_sort>>.", detailedDescription="The order that <<esql-multivalued-fields, multivalued fields>> are read from\nunderlying storage is not guaranteed. It is **frequently** ascending, but don\u2019t\nrely on that.", examples={@Example(file="ints", tag="mv_slice_positive"), @Example(file="ints", tag="mv_slice_negative")})
    public MvSlice(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression. If `null`, the function returns `null`.") Expression field, @Param(name="start", type={"integer"}, description="Start position. If `null`, the function returns `null`. The start argument can be negative. An index of -1 is used to specify the last value in the list.") Expression start, @Param(name="end", type={"integer"}, description="End position(included). Optional; if omitted, the position at `start` is returned. The end argument can be negative. An index of -1 is used to specify the last value in the list.", optional=true) Expression end) {
        super(source, end == null ? Arrays.asList(field, start, start) : Arrays.asList(field, start, end));
        this.field = field;
        this.start = start;
        this.end = end;
    }

    private MvSlice(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeOptionalNamedWriteable((NamedWriteable)this.end);
    }

    public String getWriteableName() {
        return MvSlice.ENTRY.name;
    }

    Expression field() {
        return this.field;
    }

    Expression start() {
        return this.start;
    }

    Expression end() {
        return this.end;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType((Expression)this.start, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.end != null && (resolution = TypeResolutions.isType((Expression)this.end, dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{"integer"})).unresolved()) {
            return resolution;
        }
        return resolution;
    }

    public boolean foldable() {
        return this.field.foldable() && this.start.foldable() && (this.end == null || this.end.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.start.foldable() && this.end.foldable()) {
            int startOffset = EsqlDataTypeConverter.stringToInt(String.valueOf(this.start.fold(toEvaluator.foldCtx())));
            int endOffset = EsqlDataTypeConverter.stringToInt(String.valueOf(this.end.fold(toEvaluator.foldCtx())));
            MvSlice.checkStartEnd(startOffset, endOffset);
        }
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.BOOLEAN -> new MvSliceBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.BYTES_REF -> new MvSliceBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.DOUBLE -> new MvSliceDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.INT -> new MvSliceIntEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.LONG -> new MvSliceLongEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSlice(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSlice::new, (Object)this.field, (Object)this.start, (Object)this.end);
    }

    public DataType dataType() {
        return this.field.dataType().noText();
    }

    static int adjustIndex(int oldOffset, int fieldValueCount, int first) {
        return oldOffset < 0 ? oldOffset + fieldValueCount + first : oldOffset + first;
    }

    static void checkStartEnd(int start, int end) throws InvalidArgumentException {
        if (start > end) {
            throw new InvalidArgumentException("Start offset is greater than end offset", new Object[0]);
        }
        if (start < 0 && end >= 0) {
            throw new InvalidArgumentException("Start and end offset have different signs", new Object[0]);
        }
    }

    static void process(BooleanBlock.Builder builder, int position, BooleanBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendBoolean(field.getBoolean(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendBoolean(field.getBoolean(i));
        }
        builder.endPositionEntry();
    }

    static void process(IntBlock.Builder builder, int position, IntBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendInt(field.getInt(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendInt(field.getInt(i));
        }
        builder.endPositionEntry();
    }

    static void process(LongBlock.Builder builder, int position, LongBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendLong(field.getLong(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendLong(field.getLong(i));
        }
        builder.endPositionEntry();
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendDouble(field.getDouble(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendDouble(field.getDouble(i));
        }
        builder.endPositionEntry();
    }

    static void process(BytesRefBlock.Builder builder, int position, BytesRefBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        BytesRef fieldScratch = new BytesRef();
        if (mvStartIndex == mvEndIndex) {
            builder.appendBytesRef(field.getBytesRef(mvStartIndex, fieldScratch));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendBytesRef(field.getBytesRef(i, fieldScratch));
        }
        builder.endPositionEntry();
    }
}

