/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTruncDateNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTruncDatetimeEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class DateTrunc
extends EsqlConfigurationFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateTrunc", DateTrunc::new);
    private static final Map<DataType, DateTruncFactoryProvider> evaluatorMap = Map.ofEntries(Map.entry(DataType.DATETIME, DateTruncDatetimeEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, DateTruncDateNanosEvaluator.Factory::new));
    private final Expression interval;
    private final Expression timestampField;

    @FunctionInfo(returnType={"date", "date_nanos"}, description="Rounds down a date to the closest interval since epoch, which starts at `0001-01-01T00:00:00Z`.", examples={@Example(file="date_trunc", tag="docsDateTrunc"), @Example(description="Combine `DATE_TRUNC` with [`STATS`](/reference/query-languages/esql/commands/stats-by.md) to create date histograms. For example, the number of hires per year:", file="date_trunc", tag="docsDateTruncHistogram"), @Example(description="Or an hourly error rate:", file="conditional", tag="docsCaseHourlyErrorRate")})
    public DateTrunc(Source source, @Param(name="interval", type={"date_period", "time_duration"}, description="Interval; expressed using the timespan literal syntax.") Expression interval, @Param(name="date", type={"date", "date_nanos"}, description="Date expression") Expression field, Configuration configuration) {
        super(source, List.of(interval, field), configuration);
        this.interval = interval;
        this.timestampField = field;
    }

    private DateTrunc(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.interval);
        out.writeNamedWriteable((NamedWriteable)this.timestampField);
    }

    public String getWriteableName() {
        return DateTrunc.ENTRY.name;
    }

    public Expression interval() {
        return this.interval;
    }

    public Expression field() {
        return this.timestampField;
    }

    public ZoneId zoneId() {
        return this.configuration().zoneId();
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        String operationName = this.sourceText();
        return TypeResolutions.isType((Expression)this.interval, DataType::isTemporalAmount, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"dateperiod", "timeduration"}).and(TypeResolutions.isType((Expression)this.timestampField, evaluatorMap::containsKey, (String)operationName, (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"date_nanos or datetime"}));
    }

    public DataType dataType() {
        return this.timestampField.dataType() == DataType.NULL ? DataType.DATETIME : this.timestampField.dataType();
    }

    static long processDatetime(long fieldVal, Rounding.Prepared rounding) {
        return rounding.round(fieldVal);
    }

    static long processDateNanos(long fieldVal, Rounding.Prepared rounding) {
        return DateUtils.toNanoSeconds((long)rounding.round(DateUtils.toMilliSeconds((long)fieldVal)));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateTrunc(this.source(), newChildren.get(0), newChildren.get(1), this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateTrunc::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)), (Object)this.configuration());
    }

    public boolean foldable() {
        return this.interval.foldable() && this.timestampField.foldable();
    }

    public static Rounding.Prepared createRounding(Object interval, ZoneId timeZone, Long min, Long max) {
        if (interval instanceof Period) {
            Period period = (Period)interval;
            return DateTrunc.createRounding(period, timeZone, min, max);
        }
        if (interval instanceof Duration) {
            Duration duration = (Duration)interval;
            return DateTrunc.createRounding(duration, timeZone, min, max);
        }
        throw new IllegalArgumentException("Time interval is not supported");
    }

    private static Rounding.Prepared createRounding(Period period, ZoneId timeZone, Long min, Long max) {
        Rounding.Builder rounding;
        if (period == null || period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        long periods = period.getUnits().stream().filter(unit -> period.get((TemporalUnit)unit) != 0L).count();
        if (periods != 1L) {
            throw new IllegalArgumentException("Time interval with multiple periods is not supported");
        }
        boolean tryPrepareWithMinMax = true;
        if (period.getDays() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.DAY_OF_MONTH);
        } else if (period.getDays() == 7) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        } else if (period.getDays() > 1) {
            rounding = new Rounding.Builder(new TimeValue((long)period.getDays(), TimeUnit.DAYS));
            tryPrepareWithMinMax = false;
        } else if (period.getMonths() == 3) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        } else if (period.getMonths() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.MONTH_OF_YEAR);
        } else if (period.getMonths() > 0) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.MONTHS_OF_YEAR, period.getMonths());
            tryPrepareWithMinMax = false;
        } else if (period.getYears() == 1) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        } else if (period.getYears() > 0) {
            rounding = new Rounding.Builder(Rounding.DateTimeUnit.YEARS_OF_CENTURY, period.getYears());
            tryPrepareWithMinMax = false;
        } else {
            throw new IllegalArgumentException("Time interval is not supported");
        }
        rounding.timeZone(timeZone);
        if (min != null && max != null && tryPrepareWithMinMax) {
            return rounding.build().prepare(min.longValue(), max.longValue());
        }
        return rounding.build().prepareForUnknown();
    }

    private static Rounding.Prepared createRounding(Duration duration, ZoneId timeZone, Long min, Long max) {
        if (duration == null || duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Zero or negative time interval is not supported");
        }
        Rounding.Builder rounding = new Rounding.Builder(TimeValue.timeValueMillis((long)duration.toMillis()));
        rounding.timeZone(timeZone);
        if (min != null && max != null) {
            return rounding.build().prepare(min.longValue(), max.longValue());
        }
        return rounding.build().prepareForUnknown();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        Object foldedInterval;
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.timestampField);
        if (!this.interval.foldable()) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval.sourceText() + "].");
        }
        try {
            foldedInterval = this.interval.fold(toEvaluator.foldCtx());
            if (foldedInterval == null) {
                throw new IllegalArgumentException("Interval cannot not be null");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Function [" + this.sourceText() + "] has invalid interval [" + this.interval.sourceText() + "]. " + e.getMessage());
        }
        return DateTrunc.evaluator(this.dataType(), this.source(), fieldEvaluator, DateTrunc.createRounding(foldedInterval, this.zoneId(), null, null));
    }

    public static EvalOperator.ExpressionEvaluator.Factory evaluator(DataType forType, Source source, EvalOperator.ExpressionEvaluator.Factory fieldEvaluator, Rounding.Prepared rounding) {
        return evaluatorMap.get(forType).apply(source, fieldEvaluator, rounding);
    }

    @FunctionalInterface
    public static interface DateTruncFactoryProvider {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, Rounding.Prepared var3);
    }
}

