/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public final class ClampMinLongEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMinLongEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator min;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMinLongEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator min, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.min = min;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock fieldBlock = (LongBlock)this.field.eval(page);){
            LongBlock longBlock;
            block20: {
                LongVector minVector;
                LongVector fieldVector;
                LongBlock minBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                minBlock = (LongBlock)this.min.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                                    if (minBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (minBlock != null) {
                                        try {
                                            minBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                minBlock.close();
                            }
                            return longBlock3;
                        }
                        minVector = minBlock.asVector();
                        if (minVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                        if (minBlock == null) break block19;
                        minBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), fieldVector, minVector).asBlock();
                if (minBlock == null) break block20;
                minBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.min.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock fieldBlock, LongBlock minBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (minBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                long field = fieldBlock.getLong(fieldBlock.getFirstValueIndex(p));
                long min = minBlock.getLong(minBlock.getFirstValueIndex(p));
                result.appendLong(ClampMin.process(field, min));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector fieldVector, LongVector minVector) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long field = fieldVector.getLong(p);
                long min = minVector.getLong(p);
                result.appendLong(p, ClampMin.process(field, min));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "ClampMinLongEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.min});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory min;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory min) {
            this.source = source;
            this.field = field;
            this.min = min;
        }

        public ClampMinLongEvaluator get(DriverContext context) {
            return new ClampMinLongEvaluator(this.source, this.field.get(context), this.min.get(context), context);
        }

        public String toString() {
            return "ClampMinLongEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
        }
    }
}

