/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;

public final class ClampMaxBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMaxBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator max;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMaxBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator max, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.max = max;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock fieldBlock = (BytesRefBlock)this.field.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector maxVector;
                BytesRefVector fieldVector;
                BytesRefBlock maxBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                maxBlock = (BytesRefBlock)this.max.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                                    if (maxBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (maxBlock != null) {
                                        try {
                                            maxBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                maxBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        maxVector = maxBlock.asVector();
                        if (maxVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                        if (maxBlock == null) break block19;
                        maxBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), fieldVector, maxVector).asBlock();
                if (maxBlock == null) break block20;
                maxBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.max.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock fieldBlock, BytesRefBlock maxBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            BytesRef maxScratch = new BytesRef();
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (maxBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                BytesRef field = fieldBlock.getBytesRef(fieldBlock.getFirstValueIndex(p), fieldScratch);
                BytesRef max = maxBlock.getBytesRef(maxBlock.getFirstValueIndex(p), maxScratch);
                result.appendBytesRef(ClampMax.process(field, max));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector fieldVector, BytesRefVector maxVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            BytesRef maxScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef field = fieldVector.getBytesRef(p, fieldScratch);
                BytesRef max = maxVector.getBytesRef(p, maxScratch);
                result.appendBytesRef(ClampMax.process(field, max));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "ClampMaxBytesRefEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.max});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory max;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory max) {
            this.source = source;
            this.field = field;
            this.max = max;
        }

        public ClampMaxBytesRefEvaluator get(DriverContext context) {
            return new ClampMaxBytesRefEvaluator(this.source, this.field.get(context), this.max.get(context), context);
        }

        public String toString() {
            return "ClampMaxBytesRefEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
        }
    }
}

