/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.LicenseAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;

public abstract class SpatialAggregateFunction
extends AggregateFunction
implements LicenseAware {
    protected final MappedFieldType.FieldExtractPreference fieldExtractPreference;

    protected SpatialAggregateFunction(Source source, Expression field, Expression filter, Expression window, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        super(source, field, filter, window, Collections.emptyList());
        this.fieldExtractPreference = fieldExtractPreference;
    }

    protected SpatialAggregateFunction(StreamInput in, MappedFieldType.FieldExtractPreference fieldExtractPreference) throws IOException {
        super(in);
        this.fieldExtractPreference = fieldExtractPreference;
    }

    public abstract SpatialAggregateFunction withFieldExtractPreference(MappedFieldType.FieldExtractPreference var1);

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return switch (this.field().dataType()) {
            case DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE -> state.isAllowedByLicense(License.OperationMode.PLATINUM);
            default -> true;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.fieldExtractPreference);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SpatialAggregateFunction other = (SpatialAggregateFunction)obj;
            return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters()) && Objects.equals(other.fieldExtractPreference, this.fieldExtractPreference);
        }
        return false;
    }

    public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
        return this.fieldExtractPreference;
    }
}

