/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class MaxOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MaxOverTime", MaxOverTime::new);

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "unsigned_long", "version"}, description="Calculates the maximum over time value of a field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="max_over_time")})
    public MaxOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "text", "unsigned_long", "version", "exponential_histogram"}) Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the maximum", optional=true) Expression window) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW));
    }

    public MaxOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private MaxOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MaxOverTime.ENTRY.name;
    }

    @Override
    public MaxOverTime withFilter(Expression filter) {
        return new MaxOverTime(this.source(), this.field(), filter, this.window());
    }

    protected NodeInfo<MaxOverTime> info() {
        return NodeInfo.create((Node)this, MaxOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public MaxOverTime replaceChildren(List<Expression> newChildren) {
        return new MaxOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Max perTimeSeriesAggregation() {
        return new Max(this.source(), this.field(), this.filter(), this.window());
    }
}

