/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.CombinatorialFunctions;
import org.ojalgo.random.AbstractDiscrete;

public class Binomial
extends AbstractDiscrete {
    private final int myCount;
    private final double myProbability;

    public static Binomial of(int count, double probability) {
        return new Binomial(count, probability);
    }

    public Binomial() {
        this(1, PrimitiveMath.HALF);
    }

    public Binomial(int count, double probability) {
        this.myCount = count;
        this.myProbability = probability;
    }

    @Override
    public double getExpected() {
        return (double)this.myCount * this.myProbability;
    }

    @Override
    public double getProbability(int value) {
        return (double)CombinatorialFunctions.subsets(this.myCount, value) * PrimitiveMath.POW.invoke(this.myProbability, (double)value) * PrimitiveMath.POW.invoke(PrimitiveMath.ONE - this.myProbability, (double)(this.myCount - value));
    }

    @Override
    public double getVariance() {
        return (double)this.myCount * this.myProbability * (PrimitiveMath.ONE - this.myProbability);
    }

    @Override
    protected double generate() {
        int retVal = 0;
        for (int i = 0; i < this.myCount; ++i) {
            retVal += (int)(this.myProbability + this.random().nextDouble());
        }
        return retVal;
    }
}

