/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.SizeLimitingStringWriter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;
import org.elasticsearch.script.mustache.MustacheInvalidParameterException;

public final class MustacheScriptEngine
implements ScriptEngine {
    public static final String DETECT_MISSING_PARAMS_OPTION = "detect_missing_params";
    private static final Logger logger = LogManager.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";
    public static final Setting<ByteSizeValue> MUSTACHE_RESULT_SIZE_LIMIT = new Setting("mustache.max_output_size_bytes", s -> "1mb", s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio((String)s, (String)"mustache.max_output_size_bytes"), new Setting.Property[]{Setting.Property.NodeScope});
    private final int sizeLimit;

    public MustacheScriptEngine(Settings settings) {
        this.sizeLimit = (int)((ByteSizeValue)MUSTACHE_RESULT_SIZE_LIMIT.get(settings)).getBytes();
    }

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> options) {
        if (!context.instanceClazz.equals(TemplateScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = MustacheScriptEngine.createMustacheFactory(options);
        StringReader reader = new StringReader(templateSource);
        try {
            Mustache template = factory.compile(reader, "query-template");
            TemplateScript.Factory compiled = params -> new MustacheExecutableScript(template, params);
            return context.factoryClazz.cast(compiled);
        }
        catch (MustacheException ex) {
            throw new ScriptException(ex.getMessage(), (Throwable)ex, List.of(), templateSource, NAME);
        }
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Set.of(TemplateScript.CONTEXT, TemplateScript.INGEST_CONTEXT);
    }

    private static CustomMustacheFactory createMustacheFactory(Map<String, String> options) {
        CustomMustacheFactory.Builder builder = CustomMustacheFactory.builder();
        if (options == null || options.isEmpty()) {
            return builder.build();
        }
        if (options.containsKey("content_type")) {
            builder.mediaType(options.get("content_type"));
        }
        if (options.containsKey(DETECT_MISSING_PARAMS_OPTION)) {
            builder.detectMissingParams(MustacheScriptEngine.getDetectMissingParamsOption(options));
        }
        return builder.build();
    }

    private static boolean getDetectMissingParamsOption(Map<String, String> options) {
        return Booleans.parseBoolean((String)options.get(DETECT_MISSING_PARAMS_OPTION));
    }

    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    extends TemplateScript {
        private final Mustache template;
        private final Map<String, Object> params;

        MustacheExecutableScript(Mustache template, Map<String, Object> params) {
            super(params);
            this.template = template;
            this.params = params;
        }

        public String execute() {
            SizeLimitingStringWriter writer = new SizeLimitingStringWriter(MustacheScriptEngine.this.sizeLimit);
            try {
                this.template.execute((Writer)writer, this.params);
            }
            catch (Exception e) {
                if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{SizeLimitingStringWriter.SizeLimitExceededException.class}) != null) {
                    throw new ElasticsearchParseException("Mustache script result size limit exceeded", (Throwable)e, new Object[0]);
                }
                if (this.shouldLogException(e)) {
                    logger.error(() -> Strings.format((String)"Error running %s", (Object[])new Object[]{this.template}), (Throwable)e);
                }
                throw new GeneralScriptException("Error running " + String.valueOf(this.template), (Throwable)e);
            }
            return writer.toString();
        }

        public boolean shouldLogException(Throwable e) {
            return e.getCause() != null && !(e.getCause() instanceof MustacheInvalidParameterException);
        }
    }
}

