/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.action.Protocol;
import org.elasticsearch.xpack.sql.action.SqlQueryTask;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlQueryRequest {
    private static final ObjectParser<SqlQueryRequest, Void> PARSER = SqlQueryRequest.objectParser(SqlQueryRequest::new);
    static final ParseField COLUMNAR = new ParseField("columnar", new String[0]);
    static final ParseField FIELD_MULTI_VALUE_LENIENCY = new ParseField("field_multi_value_leniency", new String[0]);
    static final ParseField INDEX_INCLUDE_FROZEN = new ParseField("index_include_frozen", new String[0]);
    static final ParseField BINARY_COMMUNICATION = new ParseField("binary_format", new String[0]);
    static final ParseField WAIT_FOR_COMPLETION_TIMEOUT = new ParseField("wait_for_completion_timeout", new String[0]);
    static final ParseField KEEP_ON_COMPLETION = new ParseField("keep_on_completion", new String[0]);
    static final ParseField KEEP_ALIVE = new ParseField("keep_alive", new String[0]);
    static final ParseField ALLOW_PARTIAL_SEARCH_RESULTS = new ParseField("allow_partial_search_results", new String[0]);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(SqlQueryRequest.class);
    private static final String INDEX_INCLUDE_FROZEN_DEPRECATION_MESSAGE = "[index_include_frozen] parameter is deprecated because frozen indices have been deprecated. Consider cold or frozen tiers in place of frozen indices.";
    private String cursor = "";
    private Boolean columnar = Protocol.COLUMNAR;
    private Boolean binaryCommunication = Protocol.BINARY_COMMUNICATION;
    private boolean fieldMultiValueLeniency = false;
    private boolean indexIncludeFrozen = false;
    private TimeValue waitForCompletionTimeout = Protocol.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
    private boolean keepOnCompletion = Protocol.DEFAULT_KEEP_ON_COMPLETION;
    private TimeValue keepAlive = Protocol.DEFAULT_KEEP_ALIVE;
    private boolean allowPartialSearchResults = false;

    public SqlQueryRequest() {
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, QueryBuilder filter, Map<String, Object> runtimeMappings, ZoneId zoneId, String catalog, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, Boolean columnar, String cursor, RequestInfo requestInfo, boolean fieldMultiValueLeniency, boolean indexIncludeFrozen, TimeValue waitForCompletionTimeout, boolean keepOnCompletion, TimeValue keepAlive, boolean allowPartialSearchResults) {
        super(query, params, filter, runtimeMappings, zoneId, catalog, fetchSize, requestTimeout, pageTimeout, requestInfo);
        this.cursor = cursor;
        this.columnar = columnar;
        this.fieldMultiValueLeniency = fieldMultiValueLeniency;
        this.indexIncludeFrozen = indexIncludeFrozen;
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        this.keepOnCompletion = keepOnCompletion;
        this.keepAlive = keepAlive;
        this.allowPartialSearchResults = allowPartialSearchResults;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (!Strings.hasText((String)this.query()) && !Strings.hasText((String)this.cursor)) {
            validationException = ValidateActions.addValidationError((String)"one of [query] or [cursor] is required", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public SqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.cursor = in.readString();
        this.columnar = in.readOptionalBoolean();
        this.fieldMultiValueLeniency = in.readBoolean();
        this.indexIncludeFrozen = in.readBoolean();
        this.binaryCommunication = in.readOptionalBoolean();
        this.waitForCompletionTimeout = in.readOptionalTimeValue();
        this.keepOnCompletion = in.readBoolean();
        this.keepAlive = in.readOptionalTimeValue();
        this.allowPartialSearchResults = in.readBoolean();
    }

    public String cursor() {
        return this.cursor;
    }

    public SqlQueryRequest cursor(String cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("cursor may not be null.");
        }
        this.cursor = cursor;
        return this;
    }

    public Boolean columnar() {
        return this.columnar;
    }

    public SqlQueryRequest columnar(boolean columnar) {
        this.columnar = columnar;
        return this;
    }

    public SqlQueryRequest fieldMultiValueLeniency(boolean leniency) {
        this.fieldMultiValueLeniency = leniency;
        return this;
    }

    public boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public SqlQueryRequest indexIncludeFrozen(boolean include) {
        this.indexIncludeFrozen = include;
        return this;
    }

    public boolean indexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    public SqlQueryRequest binaryCommunication(boolean binaryCommunication) {
        this.binaryCommunication = binaryCommunication;
        return this;
    }

    public Boolean binaryCommunication() {
        return this.binaryCommunication;
    }

    public SqlQueryRequest waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        return this;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public SqlQueryRequest keepOnCompletion(boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
        return this;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public SqlQueryRequest keepAlive(TimeValue keepAlive) {
        if (keepAlive != null && keepAlive.getMillis() < Protocol.MIN_KEEP_ALIVE.getMillis()) {
            throw new IllegalArgumentException("[keep_alive] must be greater than " + String.valueOf(Protocol.MIN_KEEP_ALIVE) + ", got: " + String.valueOf(keepAlive));
        }
        this.keepAlive = keepAlive;
        return this;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public SqlQueryRequest allowPartialSearchResults(boolean allowPartialSearchResults) {
        this.allowPartialSearchResults = allowPartialSearchResults;
        return this;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SqlQueryTask(id, type, action, this.getDescription(), parentTaskId, headers, null, null, this.keepAlive, this.mode(), this.version(), this.columnar());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cursor);
        out.writeOptionalBoolean(this.columnar);
        out.writeBoolean(this.fieldMultiValueLeniency);
        out.writeBoolean(this.indexIncludeFrozen);
        out.writeOptionalBoolean(this.binaryCommunication);
        out.writeOptionalTimeValue(this.waitForCompletionTimeout);
        out.writeBoolean(this.keepOnCompletion);
        out.writeOptionalTimeValue(this.keepAlive);
        out.writeBoolean(this.allowPartialSearchResults);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cursor, this.columnar, this.fieldMultiValueLeniency, this.indexIncludeFrozen, this.binaryCommunication, this.waitForCompletionTimeout, this.keepOnCompletion, this.keepAlive, this.allowPartialSearchResults);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.fieldMultiValueLeniency == ((SqlQueryRequest)((Object)obj)).fieldMultiValueLeniency && this.indexIncludeFrozen == ((SqlQueryRequest)((Object)obj)).indexIncludeFrozen && Objects.equals(this.binaryCommunication, ((SqlQueryRequest)((Object)obj)).binaryCommunication) && this.keepOnCompletion == ((SqlQueryRequest)((Object)obj)).keepOnCompletion && this.allowPartialSearchResults == ((SqlQueryRequest)((Object)obj)).allowPartialSearchResults && Objects.equals(this.cursor, ((SqlQueryRequest)((Object)obj)).cursor) && Objects.equals(this.columnar, ((SqlQueryRequest)((Object)obj)).columnar) && Objects.equals(this.waitForCompletionTimeout, ((SqlQueryRequest)((Object)obj)).waitForCompletionTimeout) && Objects.equals(this.keepAlive, ((SqlQueryRequest)((Object)obj)).keepAlive);
    }

    public String getDescription() {
        return "SQL [" + this.query() + "][" + String.valueOf(this.filter()) + "]";
    }

    public static SqlQueryRequest fromXContent(XContentParser parser) {
        SqlQueryRequest request = (SqlQueryRequest)((Object)PARSER.apply(parser, null));
        SqlQueryRequest.validateParams(request.params(), request.mode());
        return request;
    }

    static {
        PARSER.declareString(SqlQueryRequest::cursor, CURSOR);
        PARSER.declareBoolean(SqlQueryRequest::columnar, COLUMNAR);
        PARSER.declareBoolean(SqlQueryRequest::fieldMultiValueLeniency, FIELD_MULTI_VALUE_LENIENCY);
        PARSER.declareBoolean((r, v) -> {
            DEPRECATION_LOGGER.warn(DeprecationCategory.API, "sql_index_include_frozen", INDEX_INCLUDE_FROZEN_DEPRECATION_MESSAGE, new Object[0]);
            r.indexIncludeFrozen((boolean)v);
        }, INDEX_INCLUDE_FROZEN);
        PARSER.declareBoolean(SqlQueryRequest::binaryCommunication, BINARY_COMMUNICATION);
        PARSER.declareField(SqlQueryRequest::waitForCompletionTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)"wait_for_completion_timeout"), WAIT_FOR_COMPLETION_TIMEOUT, ObjectParser.ValueType.VALUE);
        PARSER.declareBoolean(SqlQueryRequest::keepOnCompletion, KEEP_ON_COMPLETION);
        PARSER.declareField(SqlQueryRequest::keepAlive, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)"keep_alive"), KEEP_ALIVE, ObjectParser.ValueType.VALUE);
        PARSER.declareBoolean(SqlQueryRequest::allowPartialSearchResults, ALLOW_PARTIAL_SEARCH_RESULTS);
    }
}

