/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;

public final class ImmutableTransactionStore
extends TransactionStore {
    private final BytesRefArray items;
    private final LongArray itemCounts;
    private final long totalItemCount;
    private final BytesRefArray transactions;
    private final LongArray transactionCounts;
    private final long totalTransactionCount;
    private final long filteredTransactionCount;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ImmutableTransactionStore.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(BytesRefArray.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(LongArray.class);

    ImmutableTransactionStore(BigArrays bigArrays, BytesRefArray items, LongArray itemCounts, long totalItemCount, BytesRefArray transactions, LongArray transactionCounts, long totalTransactionCount, long filteredTransactionCount) {
        super(bigArrays);
        this.items = items;
        this.itemCounts = itemCounts;
        this.totalItemCount = totalItemCount;
        this.transactions = transactions;
        this.transactionCounts = transactionCounts;
        this.totalTransactionCount = totalTransactionCount;
        this.filteredTransactionCount = filteredTransactionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableTransactionStore(StreamInput in, BigArrays bigArrays) throws IOException {
        super(bigArrays);
        boolean success = false;
        try {
            this.items = new BytesRefArray(in, bigArrays);
            long itemCountsSize = in.readVLong();
            this.itemCounts = bigArrays.newLongArray(itemCountsSize, true);
            int i = 0;
            while ((long)i < itemCountsSize) {
                this.itemCounts.set((long)i, in.readVLong());
                ++i;
            }
            this.totalItemCount = in.readVLong();
            this.transactions = new BytesRefArray(in, bigArrays);
            long transactionsCountsSize = in.readVLong();
            this.transactionCounts = bigArrays.newLongArray(transactionsCountsSize, true);
            int i2 = 0;
            while ((long)i2 < transactionsCountsSize) {
                this.transactionCounts.set((long)i2, in.readVLong());
                ++i2;
            }
            this.totalTransactionCount = in.readVLong();
            this.filteredTransactionCount = in.readVLong();
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public BytesRefArray getItems() {
        return this.items;
    }

    @Override
    public LongArray getItemCounts() {
        return this.itemCounts;
    }

    @Override
    public long getTotalItemCount() {
        return this.totalItemCount;
    }

    @Override
    public BytesRefArray getTransactions() {
        return this.transactions;
    }

    @Override
    public LongArray getTransactionCounts() {
        return this.transactionCounts;
    }

    @Override
    public long getTotalTransactionCount() {
        return this.totalTransactionCount;
    }

    @Override
    public long getFilteredTransactionCount() {
        return this.filteredTransactionCount;
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + BASE_RAM_BYTES_USED + this.items.ramBytesUsed() + this.itemCounts.ramBytesUsed() + this.transactions.ramBytesUsed() + this.transactionCounts.ramBytesUsed();
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.items, this.itemCounts, this.transactions, this.transactionCounts});
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.items.writeTo(out);
        long itemCountsSize = this.items.size();
        long transactionCountsSize = this.transactions.size();
        out.writeVLong(itemCountsSize);
        int i = 0;
        while ((long)i < itemCountsSize) {
            out.writeVLong(this.itemCounts.get((long)i));
            ++i;
        }
        out.writeVLong(this.totalItemCount);
        this.transactions.writeTo(out);
        out.writeVLong(transactionCountsSize);
        i = 0;
        while ((long)i < transactionCountsSize) {
            out.writeVLong(this.transactionCounts.get((long)i));
            ++i;
        }
        out.writeVLong(this.totalTransactionCount);
        out.writeVLong(this.filteredTransactionCount);
    }
}

