/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.xpack.rank.rrf.RRFRankDoc;

public class RRFRankShardResult
implements RankShardResult {
    public final int queryCount;
    public final RRFRankDoc[] rrfRankDocs;

    public RRFRankShardResult(int queryCount, RRFRankDoc[] rrfRankDocs) {
        this.queryCount = queryCount;
        this.rrfRankDocs = Objects.requireNonNull(rrfRankDocs);
    }

    public RRFRankShardResult(StreamInput in) throws IOException {
        this.queryCount = in.readVInt();
        this.rrfRankDocs = (RRFRankDoc[])in.readArray(RRFRankDoc::new, RRFRankDoc[]::new);
    }

    public String getWriteableName() {
        return "rrf";
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryCount);
        out.writeArray((Writeable[])this.rrfRankDocs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RRFRankShardResult that = (RRFRankShardResult)o;
        return this.queryCount == that.queryCount && Arrays.equals((Object[])this.rrfRankDocs, (Object[])that.rrfRankDocs);
    }

    public int hashCode() {
        int result = Objects.hash(this.queryCount);
        result = 31 * result + Arrays.hashCode((Object[])this.rrfRankDocs);
        return result;
    }

    public String toString() {
        return "RRFRankShardResult{queryCount=" + this.queryCount + ", rrfRankDocs=" + Arrays.toString((Object[])this.rrfRankDocs) + "}";
    }
}

