/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.network.NetworkDirectionUtils;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public class NetworkDirectionProcessor
extends AbstractProcessor {
    public static final String TYPE = "network_direction";
    private final String sourceIpField;
    private final String destinationIpField;
    private final String targetField;
    private final List<TemplateScript.Factory> internalNetworks;
    private final String internalNetworksField;
    private final boolean ignoreMissing;

    NetworkDirectionProcessor(String tag, String description, String sourceIpField, String destinationIpField, String targetField, List<TemplateScript.Factory> internalNetworks, String internalNetworksField, boolean ignoreMissing) {
        super(tag, description);
        this.sourceIpField = sourceIpField;
        this.destinationIpField = destinationIpField;
        this.targetField = targetField;
        this.internalNetworks = internalNetworks;
        this.internalNetworksField = internalNetworksField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getSourceIpField() {
        return this.sourceIpField;
    }

    public String getDestinationIpField() {
        return this.destinationIpField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public List<TemplateScript.Factory> getInternalNetworks() {
        return this.internalNetworks;
    }

    public String getInternalNetworksField() {
        return this.internalNetworksField;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        String direction = this.getDirection(ingestDocument);
        if (direction == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("unable to calculate network direction from document");
        }
        ingestDocument.setFieldValue(this.targetField, (Object)direction);
        return ingestDocument;
    }

    private String getDirection(IngestDocument d) throws Exception {
        List<Object> networks = new ArrayList();
        if (this.internalNetworksField != null) {
            List stringList = (List)d.getFieldValue(this.internalNetworksField, networks.getClass(), this.ignoreMissing);
            if (stringList == null) {
                return null;
            }
            networks.addAll(stringList);
        } else {
            networks = this.internalNetworks.stream().map(network -> d.renderTemplate(network)).toList();
        }
        String sourceIpAddrString = (String)d.getFieldValue(this.sourceIpField, String.class, this.ignoreMissing);
        if (sourceIpAddrString == null) {
            return null;
        }
        String destIpAddrString = (String)d.getFieldValue(this.destinationIpField, String.class, this.ignoreMissing);
        if (destIpAddrString == null) {
            return null;
        }
        boolean sourceInternal = NetworkDirectionUtils.isInternal(networks, (String)sourceIpAddrString);
        boolean destinationInternal = NetworkDirectionUtils.isInternal(networks, (String)destIpAddrString);
        return NetworkDirectionUtils.getDirection((boolean)sourceInternal, (boolean)destinationInternal);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;
        static final String DEFAULT_SOURCE_IP = "source.ip";
        static final String DEFAULT_DEST_IP = "destination.ip";
        static final String DEFAULT_TARGET = "network.direction";

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public NetworkDirectionProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String sourceIpField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"source_ip", (String)DEFAULT_SOURCE_IP);
            String destIpField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"destination_ip", (String)DEFAULT_DEST_IP);
            String targetField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DEFAULT_TARGET);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)true);
            List internalNetworks = ConfigurationUtils.readOptionalList((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"internal_networks");
            String internalNetworksField = ConfigurationUtils.readOptionalStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"internal_networks_field");
            if (internalNetworks == null && internalNetworksField == null) {
                throw ConfigurationUtils.newConfigurationException((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)"or [internal_networks_field] must be specified");
            }
            if (internalNetworks != null && internalNetworksField != null) {
                throw ConfigurationUtils.newConfigurationException((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)"and [internal_networks_field] cannot both be used in the same processor");
            }
            List<TemplateScript.Factory> internalNetworkTemplates = null;
            if (internalNetworks != null) {
                internalNetworkTemplates = internalNetworks.stream().map(n -> ConfigurationUtils.compileTemplate((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)n, (ScriptService)this.scriptService)).toList();
            }
            return new NetworkDirectionProcessor(processorTag, description, sourceIpField, destIpField, targetField, internalNetworkTemplates, internalNetworksField, ignoreMissing);
        }
    }
}

