/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.rollup.action.RollableIndexCaps;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.rollup.action.TransportGetRollupCapsAction;

public class TransportGetRollupIndexCapsAction
extends HandledTransportAction<GetRollupIndexCapsAction.Request, GetRollupIndexCapsAction.Response> {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportGetRollupCapsAction.class);
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final Executor managementExecutor;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportGetRollupIndexCapsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver) {
        super("indices:data/read/xpack/rollup/get/index/caps", transportService, actionFilters, GetRollupIndexCapsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.managementExecutor = transportService.getThreadPool().executor("management");
        this.resolver = indexNameExpressionResolver;
        this.projectResolver = projectResolver;
    }

    protected void doExecute(Task task, GetRollupIndexCapsAction.Request request, ActionListener<GetRollupIndexCapsAction.Response> listener) {
        DEPRECATION_LOGGER.warn(DeprecationCategory.API, "rollup_removal", "The rollup functionality will be removed in Elasticsearch 10.0. See docs for more information.", new Object[0]);
        this.managementExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked((IndicesRequest)request, (ActionListener<GetRollupIndexCapsAction.Response>)l)));
    }

    private void doExecuteForked(IndicesRequest request, ActionListener<GetRollupIndexCapsAction.Response> listener) {
        Transports.assertNotTransportThread((String)"retrieving rollup job index caps may be expensive");
        ProjectMetadata project = this.projectResolver.getProjectMetadata(this.clusterService.state());
        String[] indices = this.resolver.concreteIndexNames(project, request.indicesOptions(), request);
        Map<String, RollableIndexCaps> allCaps = TransportGetRollupIndexCapsAction.getCapsByRollupIndex(new HashSet<String>(Arrays.asList(indices)), project.indices());
        listener.onResponse((Object)new GetRollupIndexCapsAction.Response(allCaps));
    }

    static Map<String, RollableIndexCaps> getCapsByRollupIndex(Collection<String> resolvedIndexNames, Map<String, IndexMetadata> indices) {
        TreeMap allCaps = new TreeMap();
        indices.entrySet().stream().filter(entry -> resolvedIndexNames.contains(entry.getKey())).forEach(entry -> TransportGetRollupCapsAction.findRollupIndexCaps((String)entry.getKey(), (IndexMetadata)entry.getValue()).ifPresent(cap -> cap.getJobCaps().forEach(jobCap -> {
            ArrayList<RollupJobCaps> indexCaps = (ArrayList<RollupJobCaps>)allCaps.get(jobCap.getRollupIndex());
            if (indexCaps == null) {
                indexCaps = new ArrayList<RollupJobCaps>();
            }
            indexCaps.add((RollupJobCaps)jobCap);
            allCaps.put(jobCap.getRollupIndex(), indexCaps);
        })));
        return allCaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RollableIndexCaps((String)e.getKey(), (List)e.getValue())));
    }
}

