/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference;

import java.util.Map;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceHelpers;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;

public interface InferenceModel
extends Accountable {
    public static double[] extractFeatures(String[] featureNames, Map<String, Object> fields) {
        double[] features = new double[featureNames.length];
        int i = 0;
        for (String featureName : featureNames) {
            Double val = InferenceHelpers.toDouble(fields.get(featureName));
            features[i++] = val == null ? Double.NaN : val;
        }
        return features;
    }

    public String[] getFeatureNames();

    public TargetType targetType();

    public InferenceResults infer(Map<String, Object> var1, InferenceConfig var2, @Nullable Map<String, String> var3);

    public InferenceResults infer(double[] var1, InferenceConfig var2);

    public boolean supportsFeatureImportance();

    public String getName();

    public void rewriteFeatureIndices(Map<String, Integer> var1);
}

