/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregatorFactory;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregatorSupplier;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;

public class BoxplotAggregationBuilder
extends ValuesSourceAggregationBuilder.MetricsAggregationBuilder<BoxplotAggregationBuilder> {
    public static final String NAME = "boxplot";
    public static final ValuesSourceRegistry.RegistryKey<BoxplotAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("boxplot", BoxplotAggregatorSupplier.class);
    public static final ObjectParser<BoxplotAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"boxplot", BoxplotAggregationBuilder::new);
    private double compression = 100.0;
    private TDigestExecutionHint executionHint;

    public BoxplotAggregationBuilder(String name) {
        super(name);
    }

    protected BoxplotAggregationBuilder(BoxplotAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder.LeafOnly)clone, factoriesBuilder, metadata);
        this.compression = clone.compression;
        this.executionHint = clone.executionHint;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        BoxplotAggregatorFactory.registerAggregators(builder);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new BoxplotAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public BoxplotAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.compression = in.readDouble();
        this.executionHint = (TDigestExecutionHint)in.readOptionalWriteable(TDigestExecutionHint::readFrom);
    }

    public Set<String> metricNames() {
        return InternalBoxplot.METRIC_NAMES;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.compression);
        out.writeOptionalWriteable((Writeable)this.executionHint);
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public BoxplotAggregationBuilder compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    public BoxplotAggregationBuilder parseExecutionHint(String executionHint) {
        this.executionHint = TDigestExecutionHint.parse((String)executionHint);
        return this;
    }

    public double compression() {
        return this.compression;
    }

    protected BoxplotAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        BoxplotAggregatorSupplier aggregatorSupplier = (BoxplotAggregatorSupplier)context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        if (this.executionHint == null) {
            this.executionHint = TDigestExecutionHint.parse((String)((String)context.getClusterSettings().get(TDigestExecutionHint.SETTING)));
        }
        return new BoxplotAggregatorFactory(this.name, config, this.compression, this.executionHint, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PercentilesMethod.COMPRESSION_FIELD.getPreferredName(), this.compression);
        if (this.executionHint != null) {
            builder.field(PercentilesMethod.EXECUTION_HINT_FIELD.getPreferredName(), (Enum)this.executionHint);
        }
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BoxplotAggregationBuilder other = (BoxplotAggregationBuilder)((Object)obj);
        return Objects.equals(this.compression, other.compression) && Objects.equals(this.executionHint, other.executionHint);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.compression, this.executionHint);
    }

    public String getType() {
        return NAME;
    }

    public Optional<Set<String>> getOutputFieldNames() {
        return Optional.of(InternalBoxplot.METRIC_NAMES);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, (boolean)true, (boolean)true, (boolean)false);
        PARSER.declareDouble(BoxplotAggregationBuilder::compression, PercentilesMethod.COMPRESSION_FIELD);
        PARSER.declareString(BoxplotAggregationBuilder::parseExecutionHint, PercentilesMethod.EXECUTION_HINT_FIELD);
    }
}

