/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.completion;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiModel;
import org.elasticsearch.xpack.inference.services.openshiftai.action.OpenShiftAiActionVisitor;
import org.elasticsearch.xpack.inference.services.openshiftai.completion.OpenShiftAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class OpenShiftAiChatCompletionModel
extends OpenShiftAiModel {
    public OpenShiftAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, OpenShiftAiChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    public OpenShiftAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, OpenShiftAiChatCompletionServiceSettings serviceSettings, SecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)EmptyTaskSettings.INSTANCE), new ModelSecrets(secrets));
    }

    public static OpenShiftAiChatCompletionModel of(OpenShiftAiChatCompletionModel model, String modelId) {
        if (modelId == null || Objects.equals(model.getServiceSettings().modelId(), modelId)) {
            return model;
        }
        OpenShiftAiChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        OpenShiftAiChatCompletionServiceSettings overriddenServiceSettings = new OpenShiftAiChatCompletionServiceSettings(modelId, originalModelServiceSettings.uri(), originalModelServiceSettings.rateLimitSettings());
        return new OpenShiftAiChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    @Override
    public OpenShiftAiChatCompletionServiceSettings getServiceSettings() {
        return (OpenShiftAiChatCompletionServiceSettings)super.getServiceSettings();
    }

    @Override
    public ExecutableAction accept(OpenShiftAiActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this);
    }
}

