/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiServiceSettings;
import org.elasticsearch.xpack.inference.services.openshiftai.action.OpenShiftAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class OpenShiftAiModel
extends RateLimitGroupingModel {
    protected OpenShiftAiModel(ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
    }

    protected OpenShiftAiModel(RateLimitGroupingModel model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    protected OpenShiftAiModel(RateLimitGroupingModel model, TaskSettings taskSettings) {
        super(model, taskSettings);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.getServiceSettings().rateLimitSettings();
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.getServiceSettings().uri(), this.getServiceSettings().modelId());
    }

    public OpenShiftAiServiceSettings getServiceSettings() {
        return (OpenShiftAiServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public abstract ExecutableAction accept(OpenShiftAiActionVisitor var1, Map<String, Object> var2);
}

