/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class IbmWatsonxChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
IbmWatsonxRateLimitServiceSettings {
    public static final String NAME = "ibm_watsonx_completion_service_settings";
    private static final TransportVersion ML_INFERENCE_IBM_WATSONX_COMPLETION_ADDED = TransportVersion.fromName((String)"ml_inference_ibm_watsonx_completion_added");
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(120L);
    private final URI uri;
    private final String apiVersion;
    private final String modelId;
    private final String projectId;
    private final RateLimitSettings rateLimitSettings;

    public static IbmWatsonxChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractRequiredString(map, "url", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        String apiVersion = ServiceUtils.extractRequiredString(map, "api_version", "service_settings", validationException);
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        String projectId = ServiceUtils.extractRequiredString(map, "project_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "watsonxai", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new IbmWatsonxChatCompletionServiceSettings(uri, apiVersion, modelId, projectId, rateLimitSettings);
    }

    public IbmWatsonxChatCompletionServiceSettings(URI uri, String apiVersion, String modelId, String projectId, @Nullable RateLimitSettings rateLimitSettings) {
        this.uri = uri;
        this.apiVersion = apiVersion;
        this.projectId = projectId;
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public IbmWatsonxChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createUri(in.readString());
        this.apiVersion = in.readString();
        this.modelId = in.readString();
        this.projectId = in.readString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public URI uri() {
        return this.uri;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    public String projectId() {
        return this.projectId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("url", this.uri.toString());
        builder.field("api_version", this.apiVersion);
        builder.field("model_id", this.modelId);
        builder.field("project_id", this.projectId);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_IBM_WATSONX_COMPLETION_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
        out.writeString(this.apiVersion);
        out.writeString(this.modelId);
        out.writeString(this.projectId);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IbmWatsonxChatCompletionServiceSettings that = (IbmWatsonxChatCompletionServiceSettings)object;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.apiVersion, that.apiVersion) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.apiVersion, this.modelId, this.projectId, this.rateLimitSettings);
    }
}

