/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxRerankRequestManager;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.action.IbmWatsonxActionVisitor;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.completion.IbmWatsonxChatCompletionModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.request.IbmWatsonxChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankModel;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class IbmWatsonxActionCreator
implements IbmWatsonxActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    static final String COMPLETION_REQUEST_TYPE = "IBM watsonx completions";
    static final String USER_ROLE = "user";
    static final ResponseHandler COMPLETION_HANDLER = new IbmWatsonxCompletionResponseHandler("IBM watsonx completions", OpenAiChatCompletionResponseEntity::fromResponse);

    public IbmWatsonxActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(IbmWatsonxEmbeddingsModel model, Map<String, Object> taskSettings) {
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("IBM watsonx embeddings");
        return new SenderExecutableAction(this.sender, this.getEmbeddingsRequestManager(model, this.serviceComponents.truncator(), this.serviceComponents.threadPool()), failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(IbmWatsonxRerankModel model, Map<String, Object> taskSettings) {
        IbmWatsonxRerankModel overriddenModel = IbmWatsonxRerankModel.of(model, taskSettings);
        IbmWatsonxRerankRequestManager requestCreator = IbmWatsonxRerankRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = IbmWatsonxActionCreator.buildErrorMessage(TaskType.RERANK, overriddenModel.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, requestCreator, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(IbmWatsonxChatCompletionModel chatCompletionModel) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), chatCompletionModel, COMPLETION_HANDLER, inputs -> new IbmWatsonxChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), chatCompletionModel), ChatCompletionInput.class);
        String failedToSendRequestErrorMessage = IbmWatsonxActionCreator.buildErrorMessage(TaskType.COMPLETION, chatCompletionModel.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, failedToSendRequestErrorMessage, COMPLETION_REQUEST_TYPE);
    }

    protected IbmWatsonxEmbeddingsRequestManager getEmbeddingsRequestManager(IbmWatsonxEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        return new IbmWatsonxEmbeddingsRequestManager(model, truncator, threadPool);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)"Failed to send IBM watsonx %s request from inference entity id [%s]", (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

