/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq.completion;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.groq.GroqService;
import org.elasticsearch.xpack.inference.services.openai.OpenAiTaskSettings;

public class GroqChatCompletionTaskSettings
extends OpenAiTaskSettings<GroqChatCompletionTaskSettings> {
    public static final String NAME = "groq_completion_task_settings";

    public GroqChatCompletionTaskSettings(Map<String, Object> map) {
        super(map);
    }

    public GroqChatCompletionTaskSettings(@Nullable String user, @Nullable Map<String, String> headers) {
        super(user, headers);
    }

    public GroqChatCompletionTaskSettings(StreamInput in) throws IOException {
        super(GroqChatCompletionTaskSettings.readTaskSettingsFromStream(in));
    }

    private static OpenAiTaskSettings.Settings readTaskSettingsFromStream(StreamInput in) throws IOException {
        String user = in.readOptionalString();
        Map headers = in.readOptionalImmutableMap(StreamInput::readString, StreamInput::readString);
        return GroqChatCompletionTaskSettings.createSettings(user, headers);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return GroqService.GROQ_INFERENCE_SERVICE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user());
        out.writeOptionalMap(this.headers(), StreamOutput::writeString, StreamOutput::writeString);
    }

    @Override
    protected GroqChatCompletionTaskSettings create(@Nullable String user, @Nullable Map<String, String> headers) {
        return new GroqChatCompletionTaskSettings(user, headers);
    }
}

