/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.groq.action.GroqActionVisitor;
import org.elasticsearch.xpack.inference.services.groq.completion.GroqChatCompletionModel;
import org.elasticsearch.xpack.inference.services.groq.request.GroqUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class GroqActionCreator
implements GroqActionVisitor {
    public static final String COMPLETION_ERROR_PREFIX = "Groq chat completions";
    public static final String COMPLETION_REQUEST_TYPE = "groq completion";
    private static final String USER_ROLE = "user";
    public static final ResponseHandler COMPLETION_HANDLER = new OpenAiChatCompletionResponseHandler("groq completion", OpenAiChatCompletionResponseEntity::fromResponse);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public GroqActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(GroqChatCompletionModel model, Map<String, Object> taskSettings) {
        GroqChatCompletionModel overriddenModel = GroqChatCompletionModel.of(model, taskSettings);
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), overriddenModel, COMPLETION_HANDLER, inputs -> new GroqUnifiedChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), overriddenModel), ChatCompletionInput.class);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(COMPLETION_ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }
}

