/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.groq;

import java.net.URI;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.groq.GroqRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.groq.action.GroqActionVisitor;
import org.elasticsearch.xpack.inference.services.openai.OpenAiModel;
import org.elasticsearch.xpack.inference.services.openai.action.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public abstract class GroqModel
extends OpenAiModel {
    protected GroqModel(ModelConfigurations configurations, ModelSecrets secrets, GroqRateLimitServiceSettings rateLimitServiceSettings, @Nullable ApiKeySecrets apiKeySecrets, URI uri) {
        super(configurations, secrets, rateLimitServiceSettings, apiKeySecrets, uri);
    }

    protected GroqModel(GroqModel model, TaskSettings taskSettings) {
        super((OpenAiModel)model, taskSettings);
    }

    protected GroqModel(GroqModel model, ServiceSettings serviceSettings) {
        super((OpenAiModel)model, serviceSettings);
    }

    @Override
    public ExecutableAction accept(OpenAiActionVisitor creator, Map<String, Object> taskSettings) {
        if (creator instanceof GroqActionVisitor) {
            GroqActionVisitor groqVisitor = (GroqActionVisitor)((Object)creator);
            return this.accept(groqVisitor, taskSettings);
        }
        throw new IllegalArgumentException("Groq models only support Groq action visitors");
    }

    public abstract ExecutableAction accept(GroqActionVisitor var1, Map<String, Object> var2);
}

