/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUnifiedChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMAuthenticationApplierFactory;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceUnifiedChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceUnifiedCompletionRequestManager
extends ElasticInferenceServiceRequestManager {
    private static final Logger logger = LogManager.getLogger(ElasticInferenceServiceUnifiedCompletionRequestManager.class);
    private static final ResponseHandler HANDLER = ElasticInferenceServiceUnifiedCompletionRequestManager.createCompletionHandler();
    private final ElasticInferenceServiceCompletionModel model;
    private final TraceContext traceContext;
    private final CCMAuthenticationApplierFactory.AuthApplier authApplier;

    public static ElasticInferenceServiceUnifiedCompletionRequestManager of(ElasticInferenceServiceCompletionModel model, ThreadPool threadPool, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
        return new ElasticInferenceServiceUnifiedCompletionRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(threadPool), Objects.requireNonNull(traceContext), Objects.requireNonNull(authApplier));
    }

    private ElasticInferenceServiceUnifiedCompletionRequestManager(ElasticInferenceServiceCompletionModel model, ThreadPool threadPool, TraceContext traceContext, CCMAuthenticationApplierFactory.AuthApplier authApplier) {
        super(threadPool, model);
        this.model = model;
        this.traceContext = traceContext;
        this.authApplier = authApplier;
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        ElasticInferenceServiceUnifiedChatCompletionRequest request = new ElasticInferenceServiceUnifiedChatCompletionRequest(inferenceInputs.castTo(UnifiedChatInput.class), this.model, this.traceContext, this.requestMetadata(), this.authApplier);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }

    private static ResponseHandler createCompletionHandler() {
        return new ElasticInferenceServiceUnifiedChatCompletionResponseHandler("elastic inference service completion", OpenAiChatCompletionResponseEntity::fromResponse);
    }
}

