/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.completion;

import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiModel;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiSecretSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.action.AzureOpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionTaskSettings;

public class AzureOpenAiCompletionModel
extends AzureOpenAiModel {
    public static AzureOpenAiCompletionModel of(AzureOpenAiCompletionModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        AzureOpenAiCompletionRequestTaskSettings requestTaskSettings = AzureOpenAiCompletionRequestTaskSettings.fromMap(taskSettings);
        return new AzureOpenAiCompletionModel(model, AzureOpenAiCompletionTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public AzureOpenAiCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AzureOpenAiCompletionServiceSettings.fromMap(serviceSettings, context), AzureOpenAiCompletionTaskSettings.fromMap(taskSettings), AzureOpenAiSecretSettings.fromMap(secrets));
    }

    AzureOpenAiCompletionModel(String inferenceEntityId, TaskType taskType, String service, AzureOpenAiCompletionServiceSettings serviceSettings, AzureOpenAiCompletionTaskSettings taskSettings, @Nullable AzureOpenAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = this.buildUriString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public AzureOpenAiCompletionModel(AzureOpenAiCompletionModel originalModel, AzureOpenAiCompletionServiceSettings serviceSettings) {
        super((AzureOpenAiModel)originalModel, (ServiceSettings)serviceSettings);
    }

    private AzureOpenAiCompletionModel(AzureOpenAiCompletionModel originalModel, AzureOpenAiCompletionTaskSettings taskSettings) {
        super((AzureOpenAiModel)originalModel, (TaskSettings)taskSettings);
    }

    public AzureOpenAiCompletionServiceSettings getServiceSettings() {
        return (AzureOpenAiCompletionServiceSettings)super.getServiceSettings();
    }

    public AzureOpenAiCompletionTaskSettings getTaskSettings() {
        return (AzureOpenAiCompletionTaskSettings)super.getTaskSettings();
    }

    public AzureOpenAiSecretSettings getSecretSettings() {
        return (AzureOpenAiSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(AzureOpenAiActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    @Override
    public String resourceName() {
        return this.getServiceSettings().resourceName();
    }

    @Override
    public String deploymentId() {
        return this.getServiceSettings().deploymentId();
    }

    @Override
    public String apiVersion() {
        return this.getServiceSettings().apiVersion();
    }

    @Override
    public String[] operationPathSegments() {
        return new String[]{"chat", "completions"};
    }
}

