/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;

public record AzureAiStudioChatCompletionRequestEntity(List<String> messages, AzureAiStudioEndpointType endpointType, @Nullable Double temperature, @Nullable Double topP, @Nullable Boolean doSample, @Nullable Integer maxNewTokens, boolean stream) implements ToXContentObject
{
    public AzureAiStudioChatCompletionRequestEntity {
        Objects.requireNonNull(messages);
        Objects.requireNonNull(endpointType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.endpointType == AzureAiStudioEndpointType.TOKEN) {
            this.createPayAsYouGoRequest(builder, params);
        } else {
            this.createRealtimeRequest(builder, params);
        }
        if (this.stream) {
            builder.field("stream", true);
        }
        builder.endObject();
        return builder;
    }

    private void createRealtimeRequest(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("input_data");
        builder.startArray("input_string");
        for (String message : this.messages) {
            this.addMessageContentObject(builder, message);
        }
        builder.endArray();
        this.addRequestParameters(builder);
        builder.endObject();
    }

    private void createPayAsYouGoRequest(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("messages");
        for (String message : this.messages) {
            this.addMessageContentObject(builder, message);
        }
        builder.endArray();
        this.addRequestParameters(builder);
    }

    private void addMessageContentObject(XContentBuilder builder, String message) throws IOException {
        builder.startObject();
        builder.field("content", message);
        builder.field("role", "user");
        builder.endObject();
    }

    private void addRequestParameters(XContentBuilder builder) throws IOException {
        if (this.temperature == null && this.topP == null && this.doSample == null && this.maxNewTokens == null) {
            return;
        }
        builder.startObject("parameters");
        if (this.temperature != null) {
            builder.field("temperature", this.temperature);
        }
        if (this.topP != null) {
            builder.field("top_p", this.topP);
        }
        if (this.doSample != null) {
            builder.field("do_sample", this.doSample);
        }
        if (this.maxNewTokens != null) {
            builder.field("max_new_tokens", this.maxNewTokens);
        }
        builder.endObject();
    }
}

