/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockRequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockEmbeddingsEntityFactory;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.embeddings.AmazonBedrockEmbeddingsResponseHandler;

public class AmazonBedrockEmbeddingsRequestManager
extends AmazonBedrockRequestManager {
    private static final Logger logger = LogManager.getLogger(AmazonBedrockEmbeddingsRequestManager.class);
    private final AmazonBedrockEmbeddingsModel embeddingsModel;
    private final Truncator truncator;

    public AmazonBedrockEmbeddingsRequestManager(AmazonBedrockEmbeddingsModel model, Truncator truncator, ThreadPool threadPool, @Nullable TimeValue timeout) {
        super(model, threadPool, timeout);
        this.embeddingsModel = model;
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        EmbeddingsInput input = inferenceInputs.castTo(EmbeddingsInput.class);
        List<String> docsInput = input.getTextInputs();
        InputType inputType = input.getInputType();
        AmazonBedrockEmbeddingsServiceSettings serviceSettings = this.embeddingsModel.getServiceSettings();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, serviceSettings.maxInputTokens());
        ToXContent requestEntity = AmazonBedrockEmbeddingsEntityFactory.createEntity(this.embeddingsModel, truncatedInput, inputType);
        AmazonBedrockEmbeddingsResponseHandler responseHandler = new AmazonBedrockEmbeddingsResponseHandler();
        AmazonBedrockEmbeddingsRequest request = new AmazonBedrockEmbeddingsRequest(this.truncator, truncatedInput, this.embeddingsModel, requestEntity, this.timeout);
        try {
            requestSender.send(logger, request, hasRequestCompletedFunction, responseHandler, listener);
        }
        catch (Exception e) {
            String errorMessage = Strings.format((String)"Failed to send [text_embedding] request from inference entity id [%s]", (Object[])new Object[]{request.getInferenceEntityId()});
            logger.warn(errorMessage, (Throwable)e);
            listener.onFailure((Exception)new ElasticsearchException(errorMessage, (Throwable)e, new Object[0]));
        }
    }
}

