/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.InferenceContext;
import org.elasticsearch.xpack.core.inference.action.EmbeddingAction;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.action.InferenceActionProxy;
import org.elasticsearch.xpack.core.inference.action.UnifiedCompletionAction;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportInferenceActionProxy
extends HandledTransportAction<InferenceActionProxy.Request, InferenceAction.Response> {
    private final ModelRegistry modelRegistry;
    private final Client client;

    @Inject
    public TransportInferenceActionProxy(TransportService transportService, ActionFilters actionFilters, ModelRegistry modelRegistry, Client client) {
        super("cluster:monitor/xpack/inference/post", transportService, actionFilters, InferenceActionProxy.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) {
        try {
            ActionListener getModelListener = listener.delegateFailureAndWrap((l, unparsedModel) -> {
                TaskType selector0$temp = unparsedModel.taskType();
                int index$1 = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CHAT_COMPLETION", "EMBEDDING"}, (TaskType)selector0$temp, index$1)) {
                    case 0: {
                        this.sendUnifiedCompletionRequest(request, (ActionListener<InferenceAction.Response>)l);
                        break;
                    }
                    case 1: {
                        this.sendEmbeddingRequest(request, (ActionListener<InferenceAction.Response>)l);
                        break;
                    }
                    default: {
                        this.sendInferenceActionRequest(request, (ActionListener<InferenceAction.Response>)l);
                    }
                }
            });
            TaskType taskType = request.getTaskType();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ANY", "CHAT_COMPLETION", "EMBEDDING"}, (TaskType)taskType, n)) {
                case 0: {
                    this.modelRegistry.getModelWithSecrets(request.getInferenceEntityId(), (ActionListener<UnparsedModel>)getModelListener);
                    break;
                }
                case 1: {
                    this.sendUnifiedCompletionRequest(request, listener);
                    break;
                }
                case 2: {
                    this.sendEmbeddingRequest(request, listener);
                    break;
                }
                default: {
                    this.sendInferenceActionRequest(request, listener);
                    break;
                }
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void sendUnifiedCompletionRequest(InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) {
        ActionListener unifiedErrorFormatListener = listener.delegateResponse((l, e) -> l.onFailure((Exception)UnifiedChatCompletionException.fromThrowable((Throwable)e)));
        try {
            UnifiedCompletionAction.Request unifiedRequest;
            if (!request.isStreaming()) {
                throw new ElasticsearchStatusException("The [chat_completion] task type only supports streaming, please try again with the _stream API", RestStatus.BAD_REQUEST, new Object[0]);
            }
            try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
                unifiedRequest = UnifiedCompletionAction.Request.parseRequest((String)request.getInferenceEntityId(), (TaskType)request.getTaskType(), (TimeValue)request.getTimeout(), (InferenceContext)request.getContext(), (XContentParser)parser);
            }
            this.execute((ActionType)UnifiedCompletionAction.INSTANCE, (ActionRequest)unifiedRequest, (ActionListener)listener);
        }
        catch (Exception e2) {
            unifiedErrorFormatListener.onFailure(e2);
        }
    }

    private void sendEmbeddingRequest(InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) throws IOException {
        EmbeddingAction.Request embeddingRequest;
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
            embeddingRequest = EmbeddingAction.Request.parseRequest((String)request.getInferenceEntityId(), (TaskType)request.getTaskType(), (TimeValue)request.getTimeout(), (InferenceContext)request.getContext(), (XContentParser)parser);
        }
        this.execute((ActionType)EmbeddingAction.INSTANCE, (ActionRequest)embeddingRequest, (ActionListener)listener);
    }

    private void sendInferenceActionRequest(InferenceActionProxy.Request request, ActionListener<InferenceAction.Response> listener) throws IOException {
        InferenceAction.Request.Builder inferenceActionRequestBuilder;
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());){
            inferenceActionRequestBuilder = InferenceAction.Request.parseRequest((String)request.getInferenceEntityId(), (TaskType)request.getTaskType(), (InferenceContext)request.getContext(), (XContentParser)parser);
            inferenceActionRequestBuilder.setInferenceTimeout(request.getTimeout()).setStream(request.isStreaming());
        }
        this.execute((ActionType)InferenceAction.INSTANCE, (ActionRequest)inferenceActionRequestBuilder.build(), (ActionListener)listener);
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Supplier supplier = threadContext.newRestorableContext(true);
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin("inference");){
            this.client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
        }
    }
}

