/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.inference.InferencePlugin;

public class InferenceLicenceCheck {
    private InferenceLicenceCheck() {
    }

    public static boolean isServiceLicenced(String serviceName, XPackLicenseState licenseState) {
        if ("elastic".equals(serviceName)) {
            return InferencePlugin.EIS_INFERENCE_FEATURE.check(licenseState);
        }
        return InferencePlugin.INFERENCE_API_FEATURE.check(licenseState);
    }

    public static ElasticsearchSecurityException complianceException(String serviceName) {
        if ("elastic".equals(serviceName)) {
            return LicenseUtils.newComplianceException((String)"Elastic Inference Service");
        }
        return LicenseUtils.newComplianceException((String)"inference");
    }
}

