/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodeDeprecationChecks;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;

public class TransportNodeDeprecationCheckAction
extends TransportNodesAction<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, NodesDeprecationCheckAction.NodeRequest, NodesDeprecationCheckAction.NodeResponse, Void> {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final PluginsService pluginsService;
    private volatile List<String> skipTheseDeprecations;

    @Inject
    public TransportNodeDeprecationCheckAction(Settings settings, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, TransportService transportService, PluginsService pluginsService, ActionFilters actionFilters) {
        super("cluster:admin/xpack/deprecation/nodes/info", clusterService, transportService, actionFilters, NodesDeprecationCheckAction.NodeRequest::new, (Executor)threadPool.executor("generic"));
        this.settings = settings;
        this.pluginsService = pluginsService;
        this.licenseState = licenseState;
        this.skipTheseDeprecations = (List)TransportDeprecationInfoAction.SKIP_DEPRECATIONS_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransportDeprecationInfoAction.SKIP_DEPRECATIONS_SETTING, this::setSkipDeprecations);
    }

    private <T> void setSkipDeprecations(List<String> skipDeprecations) {
        this.skipTheseDeprecations = Collections.unmodifiableList(skipDeprecations);
    }

    protected NodesDeprecationCheckResponse newResponse(NodesDeprecationCheckRequest request, List<NodesDeprecationCheckAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new NodesDeprecationCheckResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodesDeprecationCheckAction.NodeRequest newNodeRequest(NodesDeprecationCheckRequest request) {
        return new NodesDeprecationCheckAction.NodeRequest();
    }

    protected NodesDeprecationCheckAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodesDeprecationCheckAction.NodeResponse(in);
    }

    protected NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request, Task task) {
        return this.nodeOperation(NodeDeprecationChecks.SINGLE_NODE_CHECKS);
    }

    NodesDeprecationCheckAction.NodeResponse nodeOperation(List<NodeDeprecationChecks.NodeDeprecationCheck<Settings, PluginsAndModules, ClusterState, XPackLicenseState, DeprecationIssue>> nodeSettingsChecks) {
        Settings filteredNodeSettings = this.settings.filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        Metadata metadata = this.clusterService.state().metadata();
        Settings transientSettings = metadata.transientSettings().filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        Settings persistentSettings = metadata.persistentSettings().filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        ClusterState filteredClusterState = ClusterState.builder((ClusterState)this.clusterService.state()).metadata(Metadata.builder((Metadata)metadata).transientSettings(transientSettings).persistentSettings(persistentSettings).build()).build();
        List<DeprecationIssue> issues = nodeSettingsChecks.stream().map(c -> (DeprecationIssue)c.apply(filteredNodeSettings, this.pluginsService.info(), filteredClusterState, this.licenseState)).filter(Objects::nonNull).toList();
        return new NodesDeprecationCheckAction.NodeResponse(this.transportService.getLocalNode(), issues);
    }
}

