/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import co.elastic.logstash.api.Password;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.secret.password.PasswordPolicyParam;
import org.logstash.secret.password.PasswordPolicyType;
import org.logstash.secret.password.PasswordValidator;
import org.logstash.settings.PasswordSetting;

public class ValidatedPasswordSetting
extends PasswordSetting {
    private static final Logger LOGGER = LogManager.getLogger(ValidatedPasswordSetting.class);
    private final Map<String, Object> passwordPolicies;

    public ValidatedPasswordSetting(String name, Object defaultValue, Map<Object, Object> passwordPolicies) {
        super(name, defaultValue, false);
        this.passwordPolicies = this.convertKeyRubyLabelsToStrings(passwordPolicies);
        Password coercedDefault = this.coerce(defaultValue);
        this.validate(coercedDefault);
        this.defaultValue = coercedDefault;
    }

    private Map<String, Object> convertKeyRubyLabelsToStrings(Map<Object, Object> passwordPolicies) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : passwordPolicies.entrySet()) {
            String transformedKey = entry.getKey().toString();
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                value = this.convertKeyRubyLabelsToStrings((Map<Object, Object>)value);
            }
            result.put(transformedKey, value);
        }
        return result;
    }

    @Override
    public Password coerce(Object password) {
        if (password != null && !(password instanceof Password)) {
            throw new IllegalArgumentException("Setting `" + this.getName() + "` could not coerce LogStash::Util::Password value to password");
        }
        LOGGER.debug("Password policies: {}", this.passwordPolicies);
        Map<PasswordPolicyType, PasswordPolicyParam> policies = this.buildPasswordPolicies();
        String validatedResult = new PasswordValidator(policies).validate(((Password)password).getValue());
        if (!validatedResult.isEmpty()) {
            if ("WARN".equals(this.passwordPolicies.get("mode"))) {
                LOGGER.warn("Password {}.", (Object)validatedResult);
            } else {
                throw new IllegalArgumentException("Password " + validatedResult + ".");
            }
        }
        return (Password)password;
    }

    private Map<PasswordPolicyType, PasswordPolicyParam> buildPasswordPolicies() {
        HashMap<PasswordPolicyType, PasswordPolicyParam> policies = new HashMap<PasswordPolicyType, PasswordPolicyParam>();
        policies.put(PasswordPolicyType.EMPTY_STRING, new PasswordPolicyParam());
        Object minLengthPolicyValue = ValidatedPasswordSetting.dig(this.passwordPolicies, "length", "minimum");
        policies.put(PasswordPolicyType.LENGTH, new PasswordPolicyParam("MINIMUM_LENGTH", minLengthPolicyValue != null ? minLengthPolicyValue.toString() : ""));
        if ("REQUIRED".equals(ValidatedPasswordSetting.dig(this.passwordPolicies, "include", "upper"))) {
            policies.put(PasswordPolicyType.UPPER_CASE, new PasswordPolicyParam());
        }
        if ("REQUIRED".equals(ValidatedPasswordSetting.dig(this.passwordPolicies, "include", "lower"))) {
            policies.put(PasswordPolicyType.LOWER_CASE, new PasswordPolicyParam());
        }
        if ("REQUIRED".equals(ValidatedPasswordSetting.dig(this.passwordPolicies, "include", "digit"))) {
            policies.put(PasswordPolicyType.DIGIT, new PasswordPolicyParam());
        }
        if ("REQUIRED".equals(ValidatedPasswordSetting.dig(this.passwordPolicies, "include", "symbol"))) {
            policies.put(PasswordPolicyType.SYMBOL, new PasswordPolicyParam());
        }
        return policies;
    }

    private static Object dig(Map<String, Object> map, String ... path) {
        Object current = map;
        for (String key : path) {
            if (!(current instanceof Map)) {
                return null;
            }
            if ((current = current.get(key)) != null) continue;
            return null;
        }
        return current;
    }
}

