/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRBodyMethod
extends InterpretedIRMethod {
    public InterpretedIRBodyMethod(IRScope method2, RubyModule implementationClass) {
        super(method2, Visibility.PUBLIC, implementationClass);
        this.callCount = -1;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.EMPTY_ARRAY;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        return this.callInternal(context, self2, clazz, name2, block);
    }

    protected IRubyObject callInternal(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        InterpreterContext ic = this.ensureInstrsReady();
        boolean hasExplicitCallProtocol = ic.hasExplicitCallProtocol();
        if (!hasExplicitCallProtocol) {
            this.pre(ic, context, self2, name2, block, this.getImplementationClass());
        }
        try {
            switch (this.getIRScope().getScopeType()) {
                case MODULE_BODY: {
                    IRubyObject iRubyObject = this.INTERPRET_MODULE(ic, context, self2, clazz, this.getIRScope().getId(), block);
                    return iRubyObject;
                }
                case CLASS_BODY: {
                    IRubyObject iRubyObject = this.INTERPRET_CLASS(ic, context, self2, clazz, this.getIRScope().getId(), block);
                    return iRubyObject;
                }
                case METACLASS_BODY: {
                    IRubyObject iRubyObject = this.INTERPRET_METACLASS(ic, context, self2, clazz, "singleton class", block);
                    return iRubyObject;
                }
            }
            throw new RuntimeException("invalid body method type: " + this.getIRScope());
        }
        finally {
            if (!hasExplicitCallProtocol) {
                this.post(ic, context);
            }
        }
    }

    private IRubyObject INTERPRET_METACLASS(InterpreterContext ic, ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        return this.interpretWithBacktrace(ic, context, self2, name2, block);
    }

    private IRubyObject INTERPRET_MODULE(InterpreterContext ic, ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        return this.interpretWithBacktrace(ic, context, self2, name2, block);
    }

    private IRubyObject INTERPRET_CLASS(InterpreterContext ic, ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        return this.interpretWithBacktrace(ic, context, self2, name2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject interpretWithBacktrace(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, this.getImplementationClass().getMethodLocation(), name2, block);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }
}

