"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSOtoAPIResponse = convertSOtoAPIResponse;
exports.createDataConnectorRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertSOtoAPIResponse(savedObject) {
  return {
    id: savedObject.id,
    name: savedObject.attributes.name,
    type: savedObject.attributes.type,
    createdAt: savedObject.attributes.createdAt,
    updatedAt: savedObject.attributes.updatedAt,
    stackConnectors: savedObject.attributes.kscIds
  };
}
const createDataConnectorRequestSchema = exports.createDataConnectorRequestSchema = _configSchema.schema.object({
  type: _configSchema.schema.string({
    minLength: 1
  }),
  name: _configSchema.schema.string({
    minLength: 1
  }),
  token: _configSchema.schema.string({
    minLength: 1
  }) // in the future, this can be either token or username&password
});