"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataConnectorsServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routes = require("./routes");
var _data_sources = require("./data_sources");
var _register = require("./register");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataConnectorsServerPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    const {
      savedObjects,
      uiSettings
    } = core;
    const {
      dataSourcesRegistry
    } = plugins;

    // Register WorkplaceAI-owned data sources
    (0, _data_sources.registerDataSources)(dataSourcesRegistry);
    (0, _register.registerUISettings)({
      uiSettings
    });

    // Register saved objects type
    (0, _saved_objects.setupSavedObjects)(savedObjects);

    // Register HTTP routes
    const router = core.http.createRouter();
    (0, _routes.registerRoutes)(router, this.logger, core.getStartServices);
    return {};
  }
  start(core, plugins) {
    return {};
  }
}
exports.DataConnectorsServerPlugin = DataConnectorsServerPlugin;