"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSearchRoute = registerSearchRoute;
var _constants = require("../constants");
var _schemas = require("./schemas");
var _search = require("./search");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerSearchRoute(router) {
  const searchRoute = router.post({
    path: `${_constants2.DASHBOARD_API_PATH}/search`,
    summary: `Search dashboards`,
    ..._constants.commonRouteConfig
  });
  searchRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: {
      request: {
        body: _schemas.searchRequestBodySchema
      },
      response: {
        200: {
          body: () => _schemas.searchResponseBodySchema
        }
      }
    }
  }, async (ctx, req, res) => {
    let result;
    try {
      result = await (0, _search.search)(ctx, req.body);
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest();
    }
    return res.ok({
      body: result
    });
  });
}