"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updatedMetaSchema = exports.resolveMetaSchema = exports.createdMetaSchema = exports.baseMetaSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const baseMetaSchema = exports.baseMetaSchema = _configSchema.schema.object({
  managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  error: _configSchema.schema.maybe(_configSchema.schema.object({
    error: _configSchema.schema.string(),
    message: _configSchema.schema.string(),
    statusCode: _configSchema.schema.number(),
    metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  })),
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const createdMetaSchema = exports.createdMetaSchema = _configSchema.schema.object({
  created_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  created_by: _configSchema.schema.maybe(_configSchema.schema.string())
});
const updatedMetaSchema = exports.updatedMetaSchema = _configSchema.schema.object({
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  updated_by: _configSchema.schema.maybe(_configSchema.schema.string())
});
const resolveMetaSchema = exports.resolveMetaSchema = _configSchema.schema.object({
  outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
  alias_target_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  alias_purpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
});