"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPanelSettings = getPanelSettings;
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getPanelSettings(embeddableType, serializedState) {
  try {
    return await _kibana_services.presentationUtilService.getPanelPlacementSettings(embeddableType, serializedState);
  } catch (e) {
    // eslint-disable-next-line no-console
    console.warn(`Unable to get panel placement settings; embeddableType: ${embeddableType}, serializedState: ${serializedState}, error: ${e}`);
  }
}