"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractDashboardState = extractDashboardState;
var _extract_control_group_state = require("./extract_control_group_state");
var _extract_options = require("./extract_options");
var _extract_panels_state = require("./extract_panels_state");
var _extract_search_state = require("./extract_search_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractDashboardState(state) {
  let dashboardState = {};
  if (state && typeof state === 'object') {
    const stateAsObject = state;
    const controlGroupState = (0, _extract_control_group_state.extractControlGroupState)(stateAsObject);
    if (controlGroupState) dashboardState.controlGroupInput = controlGroupState;
    if (typeof stateAsObject.description === 'string') {
      dashboardState.description = stateAsObject.description;
    }
    if (Array.isArray(stateAsObject.tags)) {
      dashboardState.tags = stateAsObject.tags;
    }
    if (typeof stateAsObject.title === 'string') {
      dashboardState.title = stateAsObject.title;
    }
    if (Array.isArray(stateAsObject.references)) dashboardState.references = stateAsObject.references;
    if (typeof stateAsObject.viewMode === 'string') dashboardState.viewMode = stateAsObject.viewMode;
    const options = (0, _extract_options.extractOptions)(stateAsObject);
    dashboardState = {
      ...dashboardState,
      ...(0, _extract_search_state.extractSearchState)(stateAsObject),
      ...(Object.keys(options).length && {
        options
      })
    };
    const {
      panels,
      savedObjectReferences
    } = (0, _extract_panels_state.extractPanelsState)(stateAsObject);
    if (panels !== null && panels !== void 0 && panels.length) dashboardState.panels = panels;
    if (savedObjectReferences !== null && savedObjectReferences !== void 0 && savedObjectReferences.length) {
      var _dashboardState$refer;
      dashboardState.references = [...((_dashboardState$refer = dashboardState.references) !== null && _dashboardState$refer !== void 0 ? _dashboardState$refer : []), ...savedObjectReferences];
    }
  }
  return dashboardState;
}