"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSaveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _contentManagementAccessControlPublic = require("@kbn/content-management-access-control-public");
var _constants = require("@kbn/deeplinks-analytics/constants");
var _access_control_service = require("../../services/access_control_service");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_api/save_modal/save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardSaveModal = ({
  customModalTitle,
  description,
  onClose,
  onSave,
  showCopyOnSave,
  showStoreTimeOnSave = true,
  showStoreProjectRoutingOnSave = true,
  tags,
  title,
  timeRestore,
  projectRoutingRestore,
  accessControl,
  showAccessContainer
}) => {
  var _accessControl$access;
  const [selectedTags, setSelectedTags] = _react.default.useState(tags !== null && tags !== void 0 ? tags : []);
  const [persistSelectedTimeInterval, setPersistSelectedTimeInterval] = _react.default.useState(timeRestore);
  const [persistSelectedProjectRouting, setPersistSelectedProjectRouting] = _react.default.useState(projectRoutingRestore);
  const [selectedAccessMode, setSelectedAccessMode] = _react.default.useState((_accessControl$access = accessControl === null || accessControl === void 0 ? void 0 : accessControl.accessMode) !== null && _accessControl$access !== void 0 ? _accessControl$access : 'default');
  const saveDashboard = _react.default.useCallback(async ({
    newTitle,
    newDescription,
    newCopyOnSave,
    isTitleDuplicateConfirmed,
    onTitleDuplicate
  }) => onSave({
    newTitle,
    newDescription,
    newCopyOnSave,
    newTimeRestore: persistSelectedTimeInterval,
    newProjectRoutingRestore: persistSelectedProjectRouting,
    isTitleDuplicateConfirmed,
    onTitleDuplicate,
    newTags: selectedTags,
    newAccessMode: selectedAccessMode
  }), [onSave, persistSelectedTimeInterval, persistSelectedProjectRouting, selectedTags, selectedAccessMode]);
  const renderDashboardSaveOptions = (0, _react.useCallback)(() => {
    const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
    const tagSelector = savedObjectsTaggingApi ? /*#__PURE__*/_react.default.createElement(savedObjectsTaggingApi.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: selectedTags,
      onTagsSelected: selectedTagIds => {
        setSelectedTags(selectedTagIds);
      },
      markOptional: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    }) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, tagSelector, showStoreTimeOnSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "storeTimeWithDashboard",
      checked: persistSelectedTimeInterval,
      onChange: event => {
        setPersistSelectedTimeInterval(event.target.checked);
      },
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowLabel",
        defaultMessage: "Store time with dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowHelpText",
        defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 21
        }
      }),
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 17
      }
    })))) : null, showStoreProjectRoutingOnSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "storeProjectRoutingWithDashboard",
      checked: persistSelectedProjectRouting,
      onChange: event => {
        setPersistSelectedProjectRouting(event.target.checked);
      },
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeProjectRoutingWithDashboardFormRowLabel",
        defaultMessage: "Store project routing with dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeProjectRoutingWithDashboardFormRowHelpText",
        defaultMessage: "This changes the project routing to the currently selected project each time this dashboard is loaded.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 21
        }
      }),
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    })))) : null, showAccessContainer && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_contentManagementAccessControlPublic.AccessModeContainer, {
      accessControl: accessControl,
      onChangeAccessMode: setSelectedAccessMode,
      getActiveSpace: _kibana_services.spacesService === null || _kibana_services.spacesService === void 0 ? void 0 : _kibana_services.spacesService.getActiveSpace,
      getCurrentUser: _kibana_services.coreServices.userProfile.getCurrent,
      accessControlClient: (0, _access_control_service.getAccessControlClient)(),
      contentTypeId: _constants.DASHBOARD_SAVED_OBJECT_TYPE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 13
      }
    })));
  }, [persistSelectedTimeInterval, persistSelectedProjectRouting, selectedTags, showStoreTimeOnSave, showStoreProjectRoutingOnSave, accessControl, showAccessContainer]);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalWithSaveResult, {
    onSave: saveDashboard,
    onClose: onClose,
    title: title,
    description: description,
    showDescription: true,
    showCopyOnSave: showCopyOnSave,
    initialCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('dashboard.topNav.saveModal.objectType', {
      defaultMessage: 'dashboard'
    }),
    customModalTitle: customModalTitle,
    options: renderDashboardSaveOptions(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 5
    }
  });
};
exports.DashboardSaveModal = DashboardSaveModal;