"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeAccessControlManager = initializeAccessControlManager;
var _rxjs = require("rxjs");
var _constants = require("@kbn/deeplinks-analytics/constants");
var _access_control_service = require("../services/access_control_service");
var _dashboard_client = require("../dashboard_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeAccessControlManager(savedObjectResult, savedObjectId$) {
  var _savedObjectResult$da, _savedObjectResult$da2, _savedObjectResult$da3, _savedObjectResult$da4;
  const accessControl$ = new _rxjs.BehaviorSubject({
    owner: savedObjectResult === null || savedObjectResult === void 0 ? void 0 : (_savedObjectResult$da = savedObjectResult.data) === null || _savedObjectResult$da === void 0 ? void 0 : (_savedObjectResult$da2 = _savedObjectResult$da.access_control) === null || _savedObjectResult$da2 === void 0 ? void 0 : _savedObjectResult$da2.owner,
    accessMode: savedObjectResult === null || savedObjectResult === void 0 ? void 0 : (_savedObjectResult$da3 = savedObjectResult.data) === null || _savedObjectResult$da3 === void 0 ? void 0 : (_savedObjectResult$da4 = _savedObjectResult$da3.access_control) === null || _savedObjectResult$da4 === void 0 ? void 0 : _savedObjectResult$da4.access_mode
  });
  async function changeAccessMode(accessMode) {
    const dashboardId = savedObjectId$ === null || savedObjectId$ === void 0 ? void 0 : savedObjectId$.value;
    if (!dashboardId) {
      throw new Error('Cannot change access mode: Dashboard ID is not available');
    }
    try {
      const client = (0, _access_control_service.getAccessControlClient)();
      await client.changeAccessMode({
        objects: [{
          id: dashboardId,
          type: _constants.DASHBOARD_SAVED_OBJECT_TYPE
        }],
        accessMode: accessMode
      });
      const currentAccessControl = accessControl$.value;
      accessControl$.next({
        ...currentAccessControl,
        accessMode
      });
      _dashboard_client.dashboardClient.invalidateCache(dashboardId);
    } catch (error) {
      throw error;
    }
  }
  return {
    api: {
      accessControl$,
      changeAccessMode
    }
  };
}