"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prefixReferencesFromPanel = exports.getReferencesForPanelId = exports.getReferencesForControls = exports.getPanelIdFromReference = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlGroupReferencePrefix = 'controlGroup_';
const getPanelIdFromReference = reference => {
  const splits = reference.name.split(':', 1);
  return splits.length ? splits[0] : undefined;
};
exports.getPanelIdFromReference = getPanelIdFromReference;
const getReferencesForPanelId = (id, references) => {
  const prefix = `${id}:`;
  const filteredReferences = references.filter(reference => reference.name.indexOf(prefix) === 0).map(reference => ({
    ...reference,
    name: reference.name.replace(prefix, '')
  }));
  return filteredReferences;
};
exports.getReferencesForPanelId = getReferencesForPanelId;
const getReferencesForControls = references => {
  return references.filter(reference => reference.name.startsWith(controlGroupReferencePrefix));
};
exports.getReferencesForControls = getReferencesForControls;
const prefixReferencesFromPanel = (id, references) => {
  const prefix = `${id}:`;
  return references.filter(reference => reference.type !== 'tag') // panel references should never contain tags. If they do, they must be removed
  .map(reference => ({
    ...reference,
    name: `${prefix}${reference.name}`
  }));
};
exports.prefixReferencesFromPanel = prefixReferencesFromPanel;