"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanFiltersForSerialize = cleanFiltersForSerialize;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const removeUndefinedProperty = (obj, key) => {
  if (obj[key] === undefined) {
    delete obj[key];
  }
};
function cleanFiltersForSerialize(filters) {
  if (!filters) return;
  return filters.map(filter => {
    var _filter$meta;
    if (!filter.meta) {
      return filter;
    }
    const cleanedFilter = {
      ...filter
    };
    if (typeof cleanedFilter.meta.value !== 'undefined') {
      // Create a new filter object with meta excluding 'value'
      delete cleanedFilter.meta.value;
    }
    removeUndefinedProperty(cleanedFilter.meta, 'key');
    removeUndefinedProperty(cleanedFilter.meta, 'alias');
    if ((0, _esQuery.isCombinedFilter)(filter) && (_filter$meta = filter.meta) !== null && _filter$meta !== void 0 && _filter$meta.params) {
      // Recursively clean filters in combined filters
      cleanedFilter.meta.params = cleanFiltersForSerialize(cleanedFilter.meta.params);
    }
    return cleanedFilter;
  });
}