"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CPSServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CPSServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "initContext", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    (0, _defineProperty2.default)(this, "config$", void 0);
    this.initContext = {
      ...initContext
    };
    this.isServerless = initContext.env.packageInfo.buildFlavor === 'serverless';
    this.config$ = initContext.config.get();
  }
  setup(core) {
    const {
      initContext,
      config$
    } = this;
    const {
      cpsEnabled
    } = config$;

    // Register route only for serverless
    if (this.isServerless) {
      (0, _routes.registerRoutes)(core, initContext);
    }

    // Set CPS feature flag in Elasticsearch service
    core.elasticsearch.setCpsFeatureFlag(cpsEnabled);
    return {
      getCpsEnabled: () => cpsEnabled
    };
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.CPSServerPlugin = CPSServerPlugin;