"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPrebootStatusRoute = void 0;
var _coreStatusCommon = require("@kbn/core-status-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerPrebootStatusRoute = ({
  router
}) => {
  router.get({
    path: '/api/status',
    security: {
      authz: {
        enabled: false,
        reason: 'Preboot status route should be accessible without authorization.'
      },
      authc: {
        enabled: false,
        reason: 'Preboot status route should be accessible without authentication.'
      }
    },
    options: {
      tags: ['api'],
      access: 'public',
      // needs to be public to allow access from "system" users like k8s readiness probes.
      excludeFromRateLimiter: true
    },
    validate: false
  }, async (context, req, res) => {
    const body = {
      status: {
        overall: {
          level: _coreStatusCommon.ServiceStatusLevels.unavailable.toString()
        }
      }
    };
    return res.custom({
      body,
      statusCode: 503,
      bypassErrorFormat: true
    });
  });
};
exports.registerPrebootStatusRoute = registerPrebootStatusRoute;