"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidIndexName = isValidIndexName;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// see https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html for the current rules

function isValidIndexName(name) {
  const byteLength = encodeURI(name).split(/%(?:u[0-9A-F]{2})?[0-9A-F]{2}|./).length - 1;
  const reg = new RegExp('[\\\\/:*?"<>|\\s,#]+');
  const indexPatternInvalid = byteLength > 255 ||
  // name can't be greater than 255 bytes
  name !== name.toLowerCase() ||
  // name should be lowercase
  name === '.' || name === '..' ||
  // name can't be . or ..
  name.match(/^[-_+]/) !== null ||
  // name can't start with these chars
  name.match(reg) !== null; // name can't contain these chars

  return !indexPatternInvalid;
}