"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FinishUpStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _routes = require("../../routes");
var _connector_detail = require("../../connector_detail/connector_detail");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _connector_logo = _interopRequireDefault(require("./assets/connector_logo.svg"));
var _app_context = require("../../../app_context");
var _encode_path_params = require("../../shared/encode_path_params");
var _index_view_logic = require("../../search_index/index_view_logic");
var _syncs_logic = require("../../shared/header_actions/syncs_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/finish_up_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FinishUpStep = ({
  title
}) => {
  const {
    http,
    application
  } = (0, _public.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [showNext, setShowNext] = (0, _react.useState)(false);
  const {
    isWaitingForSync,
    isSyncing: isSyncingProp
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    connector
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    startSync
  } = (0, _kea.useActions)((0, _syncs_logic.SyncsLogic)({
    http
  }));
  const isSyncing = isWaitingForSync || isSyncingProp;
  const {
    plugins: {
      discover
    }
  } = (0, _app_context.useAppContext)();
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      window.scrollTo({
        behavior: 'smooth',
        top: 0
      });
    }, 100);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), isSyncing && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.syncingDataTextLabel', {
    defaultMessage: 'Syncing data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "success",
    onClick: () => {
      setShowNext(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "discoverApp",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 27
      }
    }),
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.exploreYourDataLabel', {
      defaultMessage: 'Explore your data'
    }),
    description: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.exploreYourDataDescription', {
      defaultMessage: 'See your connector documents or make a data view to explore them'
    }),
    footer: showNext ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepViewInDiscoverButton",
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.finishUpStep.euiButton.viewInDiscoverLabel', {
        defaultMessage: 'View in Discover'
      }),
      onClick: () => {
        var _discover$locator;
        discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({
          dataViewSpec: {
            title: connector === null || connector === void 0 ? void 0 : connector.name
          },
          indexPattern: connector === null || connector === void 0 ? void 0 : connector.index_name,
          title: connector === null || connector === void 0 ? void 0 : connector.name
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.viewInDiscoverButtonLabel', {
      defaultMessage: 'View in Discover'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepButton",
      color: "warning",
      iconSide: "left",
      iconType: "refresh",
      isLoading: isSyncing,
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiButton.firstSyncDataLabel', {
        defaultMessage: 'First sync data'
      }),
      onClick: () => {
        startSync(connector);
        setShowNext(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 25
      }
    }, isSyncing ? 'Syncing data' : 'First sync data'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: _connector_logo.default,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 27
      }
    }),
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.manageYourConnectorLabel', {
      defaultMessage: 'Manage your connector'
    }),
    description: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.manageYourConnectorDescription', {
      defaultMessage: 'Now you can manage your connector, schedule a sync and much more'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepManageConnectorButton",
      size: "m",
      fill: true,
      onClick: () => {
        if (connector) {
          application === null || application === void 0 ? void 0 : application.navigateToUrl((0, _encode_path_params.generateEncodedPath)(`/app/management/data/content_connectors${_routes.CONNECTOR_DETAIL_TAB_PATH}`, {
            connectorId: connector.id,
            tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
          }));
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 27
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.manageConnectorButtonLabel', {
      defaultMessage: 'Manage connector'
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.h3.queryYourDataLabel', {
    defaultMessage: 'Query your data'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      css: () => (0, _react2.css)`
                        margin-top: ${euiTheme.size.xs};
                      `,
      size: "m",
      type: "console",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 21
      }
    }),
    title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.devToolsLabel', {
      defaultMessage: 'Dev tools'
    }),
    titleSize: "xs",
    description: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiCard.devToolsDescription', {
      defaultMessage: 'Tools for interacting with your data, such as console, profiler, Grok debugger and more'
    }),
    onClick: () => {
      var _http$basePath$prepen;
      application === null || application === void 0 ? void 0 : application.navigateToUrl((_http$basePath$prepen = http === null || http === void 0 ? void 0 : http.basePath.prepend(_routes.DEV_TOOLS_CONSOLE_PATH)) !== null && _http$basePath$prepen !== void 0 ? _http$basePath$prepen : '');
    },
    display: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 17
    }
  })))))));
};
exports.FinishUpStep = FinishUpStep;