"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupAutosave = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook that sets up autosaving the Console editor input to localStorage.
 *
 * @param params The {@link SetupAutosaveParams} to use.
 */
const useSetupAutosave = params => {
  const {
    value
  } = params;
  const saveCurrentTextObject = (0, _hooks.useSaveCurrentTextObject)();
  const timerRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    function saveCurrentState() {
      try {
        saveCurrentTextObject(value);
      } catch (e) {
        // Ignoring saving error
      }
    }
    const saveDelay = 500;
    if (timerRef.current) {
      clearTimeout(timerRef.current);
    }
    timerRef.current = window.setTimeout(saveCurrentState, saveDelay);
    return () => {
      if (timerRef.current) {
        clearTimeout(timerRef.current);
      }
    };
  }, [saveCurrentTextObject, value]);
};
exports.useSetupAutosave = useSetupAutosave;